/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create.compressors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.NoSpaceLeftOnDeviceException;
import net.szum123321.textile_backup.core.create.BackupContext;
import net.szum123321.textile_backup.core.create.compressors.ZipCompressor;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;

public class ParallelZipCompressor
extends ZipCompressor {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final SimpleStackTraceElement[] STACKTRACE = new SimpleStackTraceElement[]{new SimpleStackTraceElement("sun.nio.ch.FileDispatcherImpl", "write0", true), new SimpleStackTraceElement("sun.nio.ch.FileDispatcherImpl", "write", false), new SimpleStackTraceElement("sun.nio.ch.IOUtil", "writeFromNativeBuffer", false), new SimpleStackTraceElement("sun.nio.ch.IOUtil", "write", false), new SimpleStackTraceElement("sun.nio.ch.FileChannelImpl", "write", false), new SimpleStackTraceElement("java.nio.channels.Channels", "writeFullyImpl", false), new SimpleStackTraceElement("java.nio.channels.Channels", "writeFully", false), new SimpleStackTraceElement("java.nio.channels.Channels$1", "write", false), new SimpleStackTraceElement("org.apache.commons.compress.parallel.FileBasedScatterGatherBackingStore", "writeOut", false)};
    private ParallelScatterZipCreator scatterZipCreator;

    public static ParallelZipCompressor getInstance() {
        return new ParallelZipCompressor();
    }

    @Override
    protected OutputStream createArchiveOutputStream(OutputStream stream, BackupContext ctx, int coreLimit) {
        this.scatterZipCreator = new ParallelScatterZipCreator(Executors.newFixedThreadPool(coreLimit));
        return super.createArchiveOutputStream(stream, ctx, coreLimit);
    }

    @Override
    protected void addEntry(File file, String entryName, OutputStream arc) throws IOException {
        ZipArchiveEntry entry = (ZipArchiveEntry)((ZipArchiveOutputStream)arc).createArchiveEntry(file, entryName);
        if (ZipCompressor.isDotDat(file.getName())) {
            entry.setMethod(0);
            entry.setSize(file.length());
            entry.setCompressedSize(file.length());
            entry.setCrc(ParallelZipCompressor.getCRC(file));
        } else {
            entry.setMethod(8);
        }
        entry.setTime(System.currentTimeMillis());
        this.scatterZipCreator.addArchiveEntry(entry, (InputStreamSupplier)new FileInputStreamSupplier(file));
    }

    @Override
    protected void finish(OutputStream arc) throws InterruptedException, IOException, ExecutionException {
        try {
            this.scatterZipCreator.writeTo((ZipArchiveOutputStream)arc);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause.getClass().equals(IOException.class)) {
                boolean match;
                boolean bl = match = cause.getStackTrace().length >= STACKTRACE.length;
                if (match) {
                    for (int i = 0; i < STACKTRACE.length && match; ++i) {
                        if (STACKTRACE[i].equals(cause.getStackTrace()[i])) continue;
                        match = false;
                    }
                    if (match) {
                        throw new NoSpaceLeftOnDeviceException(cause);
                    }
                }
            }
            throw e;
        }
    }

    record FileInputStreamSupplier(File sourceFile) implements InputStreamSupplier
    {
        public InputStream get() {
            try {
                return new FileInputStream(this.sourceFile);
            }
            catch (IOException e) {
                log.error("An exception occurred while trying to create an input stream from file: {}!", this.sourceFile.getName(), e);
                return null;
            }
        }
    }

    private record SimpleStackTraceElement(String className, String methodName, boolean isNative) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() == StackTraceElement.class) {
                StackTraceElement that = (StackTraceElement)o;
                return this.isNative == that.isNativeMethod() && Objects.equals(this.className, that.getClassName()) && Objects.equals(this.methodName, that.getMethodName());
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            SimpleStackTraceElement that = (SimpleStackTraceElement)o;
            return this.isNative == that.isNative && Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName);
        }
    }
}

