/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create.compressors;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.NoSpaceLeftOnDeviceException;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.create.BackupContext;

public abstract class AbstractCompressor {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createArchive(File inputFile, File outputFile, BackupContext ctx, int coreLimit) {
        Instant start = Instant.now();
        try (FileOutputStream outStream = new FileOutputStream(outputFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outStream);
             OutputStream arc = this.createArchiveOutputStream(bufferedOutputStream, ctx, coreLimit);){
            Files.walk(inputFile.toPath(), new FileVisitOption[0]).filter(path -> !Utilities.isBlacklisted(inputFile.toPath().relativize((Path)path))).map(Path::toFile).filter(File::isFile).forEach(file -> {
                block2: {
                    try {
                        this.addEntry((File)file, inputFile.toPath().relativize(file.toPath()).toString(), arc);
                    }
                    catch (IOException e) {
                        log.error("An exception occurred while trying to compress: {}", inputFile.toPath().relativize(file.toPath()).toString(), e);
                        if (ctx.getInitiator() != ActionInitiator.Player) break block2;
                        log.sendError(ctx, "Something went wrong while compressing files!", new Object[0]);
                    }
                }
            });
            this.finish(arc);
        }
        catch (NoSpaceLeftOnDeviceException e) {
            log.error("CRITICAL ERROR OCCURRED!\nThe backup is corrupt!\nDon't panic! This is a known issue!\nFor help see: https://github.com/Szum123321/textile_backup/wiki/ZIP-Problems\nIn case this isn't it here's also the exception itself", e);
            if (ctx.getInitiator() == ActionInitiator.Player) {
                log.sendError(ctx, "Backup failed. The file is corrupt.", new Object[0]);
                log.error("For help see: https://github.com/Szum123321/textile_backup/wiki/ZIP-Problems", new Object[0]);
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            log.error("An exception occurred!", e);
        }
        catch (Exception e) {
            if (ctx.getInitiator() == ActionInitiator.Player) {
                log.sendError(ctx, "Something went wrong while compressing files!", new Object[0]);
            }
        }
        finally {
            this.close();
        }
        log.sendInfoAL(ctx, "Compression took: {} seconds.", Utilities.formatDuration(Duration.between(start, Instant.now())));
    }

    protected abstract OutputStream createArchiveOutputStream(OutputStream var1, BackupContext var2, int var3) throws IOException;

    protected abstract void addEntry(File var1, String var2, OutputStream var3) throws IOException;

    protected void finish(OutputStream arc) throws InterruptedException, ExecutionException, IOException {
    }

    protected void close() {
    }
}

