/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import net.szum123321.textile_backup.Statics;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.create.BackupContext;
import net.szum123321.textile_backup.core.create.BackupHelper;
import net.szum123321.textile_backup.core.create.compressors.ParallelZipCompressor;
import net.szum123321.textile_backup.core.create.compressors.ZipCompressor;
import net.szum123321.textile_backup.core.create.compressors.tar.AbstractTarArchiver;
import net.szum123321.textile_backup.core.create.compressors.tar.ParallelBZip2Compressor;
import net.szum123321.textile_backup.core.create.compressors.tar.ParallelGzipCompressor;
import org.apache.commons.compress.compressors.lzma.LZMACompressorOutputStream;

public class MakeBackupRunnable
implements Runnable {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;
    private final BackupContext context;

    public MakeBackupRunnable(BackupContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Utilities.disableWorldSaving(this.context.getServer());
            Statics.disableWatchdog = true;
            Utilities.updateTMPFSFlag(this.context.getServer());
            log.sendInfoAL(this.context, "Starting backup", new Object[0]);
            File world = Utilities.getWorldFolder(this.context.getServer());
            log.trace("Minecraft world is: {}", world);
            File outFile = Utilities.getBackupRootPath(Utilities.getLevelName(this.context.getServer())).toPath().resolve(this.getFileName()).toFile();
            log.trace("Outfile is: {}", outFile);
            outFile.getParentFile().mkdirs();
            try {
                outFile.createNewFile();
            }
            catch (IOException e) {
                log.error("An exception occurred when trying to create new backup file!", e);
                if (this.context.getInitiator() == ActionInitiator.Player) {
                    log.sendError(this.context, "An exception occurred when trying to create new backup file!", new Object[0]);
                }
                Utilities.enableWorldSaving(this.context.getServer());
                Statics.disableWatchdog = false;
                return;
            }
            int coreCount = MakeBackupRunnable.config.get().compressionCoreCountLimit <= 0 ? Runtime.getRuntime().availableProcessors() : Math.min(MakeBackupRunnable.config.get().compressionCoreCountLimit, Runtime.getRuntime().availableProcessors());
            log.trace("Running compression on {} threads. Available cores: {}", coreCount, Runtime.getRuntime().availableProcessors());
            switch (MakeBackupRunnable.config.get().format) {
                case ZIP: {
                    if (coreCount > 1 && !Statics.disableTMPFiles) {
                        ParallelZipCompressor.getInstance().createArchive(world, outFile, this.context, coreCount);
                        break;
                    }
                    ZipCompressor.getInstance().createArchive(world, outFile, this.context, coreCount);
                    break;
                }
                case BZIP2: {
                    ParallelBZip2Compressor.getInstance().createArchive(world, outFile, this.context, coreCount);
                    break;
                }
                case GZIP: {
                    ParallelGzipCompressor.getInstance().createArchive(world, outFile, this.context, coreCount);
                    break;
                }
                case LZMA: {
                    new AbstractTarArchiver(){

                        @Override
                        protected OutputStream getCompressorOutputStream(OutputStream stream, BackupContext ctx, int coreLimit) throws IOException {
                            return new LZMACompressorOutputStream(stream);
                        }
                    }.createArchive(world, outFile, this.context, coreCount);
                    break;
                }
                case TAR: {
                    new AbstractTarArchiver().createArchive(world, outFile, this.context, coreCount);
                    break;
                }
                default: {
                    log.warn("Specified compressor ({}) is not supported! Zip will be used instead!", new Object[]{MakeBackupRunnable.config.get().format});
                    if (this.context.getInitiator() == ActionInitiator.Player) {
                        log.sendError(this.context.getCommandSource(), "Error! No correct compression format specified! Using default compressor!", new Object[0]);
                    }
                    ZipCompressor.getInstance().createArchive(world, outFile, this.context, coreCount);
                }
            }
            BackupHelper.executeFileLimit(this.context.getCommandSource(), Utilities.getLevelName(this.context.getServer()));
            if (MakeBackupRunnable.config.get().broadcastBackupDone) {
                Utilities.notifyPlayers(this.context.getServer(), this.context.getInitiatorUUID(), "Done!");
            } else {
                log.sendInfoAL(this.context, "Done!", new Object[0]);
            }
        }
        finally {
            Utilities.enableWorldSaving(this.context.getServer());
            Statics.disableWatchdog = false;
        }
    }

    private String getFileName() {
        LocalDateTime now = LocalDateTime.now();
        return Utilities.getDateTimeFormatter().format(now) + (String)(this.context.getComment() != null ? "#" + this.context.getComment().replace("#", "") : "") + MakeBackupRunnable.config.get().format.getCompleteString();
    }
}

