/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create;

import java.time.Instant;
import net.minecraft.server.MinecraftServer;
import net.szum123321.textile_backup.Statics;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.ActionInitiator;
import net.szum123321.textile_backup.core.create.BackupContext;
import net.szum123321.textile_backup.core.create.BackupHelper;

public class BackupScheduler {
    private static final ConfigHelper config = ConfigHelper.INSTANCE;
    private boolean scheduled = false;
    private long nextBackup = -1L;

    public void tick(MinecraftServer server) {
        if (BackupScheduler.config.get().backupInterval < 1L) {
            return;
        }
        long now = Instant.now().getEpochSecond();
        if (BackupScheduler.config.get().doBackupsOnEmptyServer || server.method_3760().method_14574() > 0) {
            if (this.scheduled) {
                if (this.nextBackup <= now) {
                    Statics.executorService.submit(BackupHelper.create(BackupContext.Builder.newBackupContextBuilder().setServer(server).setInitiator(ActionInitiator.Timer).saveServer().build()));
                    this.nextBackup = now + BackupScheduler.config.get().backupInterval;
                }
            } else {
                this.nextBackup = now + BackupScheduler.config.get().backupInterval;
                this.scheduled = true;
            }
        } else if (!BackupScheduler.config.get().doBackupsOnEmptyServer && server.method_3760().method_14574() == 0 && this.scheduled && this.nextBackup <= now) {
            Statics.executorService.submit(BackupHelper.create(BackupContext.Builder.newBackupContextBuilder().setServer(server).setInitiator(ActionInitiator.Timer).saveServer().build()));
            this.scheduled = false;
        }
    }
}

