/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create;

import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_2168;
import net.szum123321.textile_backup.Statics;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.core.Utilities;
import net.szum123321.textile_backup.core.create.BackupContext;
import net.szum123321.textile_backup.core.create.MakeBackupRunnable;
import org.apache.commons.io.FileUtils;

public class BackupHelper {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;

    public static Runnable create(BackupContext ctx) {
        if (BackupHelper.config.get().broadcastBackupStart) {
            Utilities.notifyPlayers(ctx.getServer(), ctx.getInitiatorUUID(), "Warning! Server backup will begin shortly. You may experience some lag.");
        } else {
            log.sendInfoAL(ctx, "Warning! Server backup will begin shortly. You may experience some lag.", new Object[0]);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Backup started ");
        builder.append(ctx.getInitiator().getPrefix());
        if (ctx.startedByPlayer()) {
            builder.append(ctx.getCommandSource().method_9223().getString());
        } else {
            builder.append(ctx.getInitiator().getName());
        }
        builder.append(" on: ");
        builder.append(Utilities.getDateTimeFormatter().format(LocalDateTime.now()));
        log.info(builder.toString(), new Object[0]);
        if (ctx.shouldSave()) {
            log.sendInfoAL(ctx, "Saving server...", new Object[0]);
            ctx.getServer().method_3760().method_14617();
            try {
                ctx.getServer().method_3723(false, true, true);
            }
            catch (Exception e) {
                log.sendErrorAL(ctx, "An exception occurred when trying to save the world!", new Object[0]);
            }
        }
        return new MakeBackupRunnable(ctx);
    }

    public static int executeFileLimit(class_2168 ctx, String worldName) {
        File root = Utilities.getBackupRootPath(worldName);
        int deletedFiles = 0;
        if (root.isDirectory() && root.exists() && root.listFiles() != null) {
            if (BackupHelper.config.get().maxAge > 0L) {
                LocalDateTime now = LocalDateTime.now();
                deletedFiles = (int)((long)deletedFiles + Arrays.stream(root.listFiles()).filter(Utilities::isValidBackup).filter(f -> now.toEpochSecond(ZoneOffset.UTC) - Utilities.getFileCreationTime(f).get().toEpochSecond(ZoneOffset.UTC) > BackupHelper.config.get().maxAge).map(f -> BackupHelper.deleteFile(f, ctx)).filter(b -> b).count());
            }
            if (BackupHelper.config.get().backupsToKeep > 0 && root.listFiles().length > BackupHelper.config.get().backupsToKeep) {
                deletedFiles = (int)((long)deletedFiles + Arrays.stream(root.listFiles()).filter(Utilities::isValidBackup).sorted(Comparator.comparing(f -> Utilities.getFileCreationTime((File)f).get()).reversed()).skip(BackupHelper.config.get().backupsToKeep).map(f -> BackupHelper.deleteFile(f, ctx)).filter(b -> b).count());
            }
            if (BackupHelper.config.get().maxSize > 0 && FileUtils.sizeOfDirectory((File)root) / 1024L > (long)BackupHelper.config.get().maxSize) {
                deletedFiles = (int)((long)deletedFiles + Arrays.stream(root.listFiles()).filter(Utilities::isValidBackup).sorted(Comparator.comparing(f -> Utilities.getFileCreationTime(f).get())).takeWhile(f -> FileUtils.sizeOfDirectory((File)root) / 1024L > (long)BackupHelper.config.get().maxSize).map(f -> BackupHelper.deleteFile(f, ctx)).filter(b -> b).count());
            }
        }
        return deletedFiles;
    }

    private static boolean deleteFile(File f, class_2168 ctx) {
        if (Statics.untouchableFile.isEmpty() || !Statics.untouchableFile.get().equals(f)) {
            if (f.delete()) {
                log.sendInfoAL(ctx, "Deleting: {}", f.getName());
                return true;
            }
            log.sendErrorAL(ctx, "Something went wrong while deleting: {}.", f.getName());
        }
        return false;
    }
}

