/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core.create;

import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import net.szum123321.textile_backup.core.ActionInitiator;
import org.jetbrains.annotations.NotNull;

public record BackupContext(@NotNull MinecraftServer server, class_2168 commandSource, ActionInitiator initiator, boolean save, String comment) {
    public MinecraftServer getServer() {
        return this.server;
    }

    public class_2168 getCommandSource() {
        return this.commandSource;
    }

    public ActionInitiator getInitiator() {
        return this.initiator;
    }

    public boolean startedByPlayer() {
        return this.initiator == ActionInitiator.Player;
    }

    public boolean shouldSave() {
        return this.save;
    }

    public String getComment() {
        return this.comment;
    }

    public UUID getInitiatorUUID() {
        return this.initiator.equals((Object)ActionInitiator.Player) && this.commandSource.method_9228() != null ? this.commandSource.method_9228().method_5667() : class_156.field_25140;
    }

    public static class Builder {
        private MinecraftServer server = null;
        private class_2168 commandSource = null;
        private ActionInitiator initiator = null;
        private boolean save = false;
        private String comment = null;
        private boolean guessInitiator = false;

        public static Builder newBackupContextBuilder() {
            return new Builder();
        }

        public Builder setCommandSource(class_2168 commandSource) {
            this.commandSource = commandSource;
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public Builder setInitiator(ActionInitiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder guessInitiator() {
            this.guessInitiator = true;
            return this;
        }

        public Builder saveServer() {
            this.save = true;
            return this;
        }

        public BackupContext build() {
            if (this.guessInitiator) {
                this.initiator = this.commandSource.method_9228() instanceof class_1657 ? ActionInitiator.Player : ActionInitiator.ServerConsole;
            } else if (this.initiator == null) {
                this.initiator = ActionInitiator.Null;
            }
            if (this.server == null) {
                if (this.commandSource != null) {
                    this.setServer(this.commandSource.method_9211());
                } else {
                    throw new RuntimeException("Neither MinecraftServer or ServerCommandSource were provided!");
                }
            }
            return new BackupContext(this.server, this.commandSource, this.initiator, this.save, this.comment);
        }
    }
}

