/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import net.szum123321.textile_backup.Statics;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;
import net.szum123321.textile_backup.config.ConfigPOJO;
import net.szum123321.textile_backup.mixin.MinecraftServerSessionAccessor;
import org.apache.commons.io.FileUtils;

public class Utilities {
    private static final ConfigHelper config = ConfigHelper.INSTANCE;
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    public static void notifyPlayers(MinecraftServer server, UUID sender, String msg) {
        class_5250 message = log.getPrefixText();
        message.method_10852((class_2561)new class_2585(msg).method_27692(class_124.field_1068));
        server.method_3760().method_14616((class_2561)message, class_2556.field_11735, sender);
    }

    public static String getLevelName(MinecraftServer server) {
        return ((MinecraftServerSessionAccessor)server).getSession().method_27005();
    }

    public static File getWorldFolder(MinecraftServer server) {
        return ((MinecraftServerSessionAccessor)server).getSession().method_27424(class_1937.field_25179).toFile();
    }

    public static File getBackupRootPath(String worldName) {
        File path = new File(Utilities.config.get().path).getAbsoluteFile();
        if (Utilities.config.get().perWorldBackup) {
            path = path.toPath().resolve(worldName).toFile();
        }
        if (!path.exists()) {
            path.mkdirs();
        }
        return path;
    }

    public static boolean updateTMPFSFlag(MinecraftServer server) {
        boolean bl = Statics.disableTMPFiles = FileUtils.sizeOfDirectory((File)Utilities.getWorldFolder(server)) >= new File(System.getProperty("java.io.tmpdir")).getFreeSpace();
        if (Statics.disableTMPFiles) {
            log.warn("Not enough space left in tmp directory!\n Might cause: https://github.com/Szum123321/textile_backup/wiki/ZIP-Problems", new Object[0]);
        }
        return Statics.disableTMPFiles;
    }

    public static void disableWorldSaving(MinecraftServer server) {
        for (class_3218 serverWorld : server.method_3738()) {
            if (serverWorld == null || serverWorld.field_13957) continue;
            serverWorld.field_13957 = true;
        }
    }

    public static void enableWorldSaving(MinecraftServer server) {
        for (class_3218 serverWorld : server.method_3738()) {
            if (serverWorld == null || !serverWorld.field_13957) continue;
            serverWorld.field_13957 = false;
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static boolean isBlacklisted(Path path) {
        if (Utilities.isWindows() && path.getFileName().toString().equals("session.lock")) {
            return true;
        }
        return Utilities.config.get().fileBlacklist.stream().anyMatch(path::startsWith);
    }

    public static Optional<ConfigPOJO.ArchiveFormat> getArchiveExtension(String fileName) {
        String[] parts = fileName.split("\\.");
        return Arrays.stream(ConfigPOJO.ArchiveFormat.values()).filter(format -> format.getLastPiece().equals(parts[parts.length - 1])).findAny();
    }

    public static Optional<ConfigPOJO.ArchiveFormat> getArchiveExtension(File f) {
        return Utilities.getArchiveExtension(f.getName());
    }

    public static Optional<LocalDateTime> getFileCreationTime(File file) {
        LocalDateTime creationTime = null;
        if (Utilities.getArchiveExtension(file).isPresent()) {
            String fileExtension = Utilities.getArchiveExtension(file).get().getCompleteString();
            try {
                creationTime = LocalDateTime.from(Utilities.getDateTimeFormatter().parse(file.getName().split(fileExtension)[0].split("#")[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (creationTime == null) {
                try {
                    creationTime = LocalDateTime.from(Utilities.getBackupDateTimeFormatter().parse(file.getName().split(fileExtension)[0].split("#")[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (creationTime == null) {
                try {
                    FileTime fileTime = (FileTime)Files.getAttribute(file.toPath(), "creationTime", new LinkOption[0]);
                    creationTime = LocalDateTime.ofInstant(fileTime.toInstant(), ZoneOffset.systemDefault());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return Optional.ofNullable(creationTime);
    }

    public static boolean isValidBackup(File f) {
        return Utilities.getArchiveExtension(f).isPresent() && Utilities.getFileCreationTime(f).isPresent() && Utilities.isFileOk(f);
    }

    public static boolean isFileOk(File f) {
        return f.exists() && f.isFile();
    }

    public static DateTimeFormatter getDateTimeFormatter() {
        return DateTimeFormatter.ofPattern(Utilities.config.get().dateTimeFormat);
    }

    public static DateTimeFormatter getBackupDateTimeFormatter() {
        return Statics.defaultDateTimeFormatter;
    }

    public static String formatDuration(Duration duration) {
        DateTimeFormatter formatter = duration.toHours() > 0L ? DateTimeFormatter.ofPattern("HH:mm:ss.SSS") : (duration.toMinutes() > 0L ? DateTimeFormatter.ofPattern("mm:ss.SSS") : DateTimeFormatter.ofPattern("ss.SSS"));
        return LocalTime.ofNanoOfDay(duration.toNanos()).format(formatter);
    }
}

