/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.config;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="textile_backup")
public class ConfigPOJO
implements ConfigData {
    @Comment(value="\nShould every world have its own backup folder?\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Gui.Excluded
    public boolean perWorldBackup = true;
    @Comment(value="\nTime between automatic backups in seconds\nWhen set to 0 backups will not be performed automatically\n")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="Create")
    public long backupInterval = 3600L;
    @Comment(value="\nDelay in seconds between typing-in /backup restore and it actually starting\n")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="Restore")
    public int restoreDelay = 30;
    @Comment(value="\nShould backups be done even if there are no players?\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Create")
    public boolean doBackupsOnEmptyServer = false;
    @Comment(value="\nShould backup be made on server shutdown?\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Create")
    public boolean shutdownBackup = true;
    @Comment(value="\nShould world be backed up before restoring a backup?\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Restore")
    public boolean backupOldWorlds = true;
    @Comment(value="\nA path to the backup folder\n")
    @ConfigEntry.Gui.NoTooltip
    public String path = "backup/";
    @Comment(value="\nThis setting allows you to exclude files form being backed-up.\nBe very careful when setting it, as it is easy corrupt your world!\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Create")
    public List<String> fileBlacklist = new ArrayList<String>();
    @Comment(value="\nShould backups be deleted after being restored?\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Restore")
    public boolean deleteOldBackupAfterRestore = true;
    @Comment(value="\nMaximum number of backups to keep. If set to 0 then no backup will be deleted based their amount\n")
    @ConfigEntry.Gui.NoTooltip
    public int backupsToKeep = 10;
    @Comment(value="\nMaximum age of backups to keep in seconds.\n If set to 0 then backups will not be deleted based their age \n")
    @ConfigEntry.Gui.NoTooltip
    public long maxAge = 0L;
    @Comment(value="\nMaximum size of backup folder in kilo bytes (1024).\nIf set to 0 then backups will not be deleted\n")
    @ConfigEntry.Gui.Tooltip
    public int maxSize = 0;
    @Comment(value="\nCompression level \n0 - 9\n Only affects zip compression.\n")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(max=9L)
    @ConfigEntry.Category(value="Create")
    public int compression = 7;
    @Comment(value="\nLimit how many cores can be used for compression.\n0 means that all available cores will be used\n")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="Create")
    public int compressionCoreCountLimit = 0;
    @Comment(value="\nAvailable formats are:\nZIP - normal zip archive using standard deflate compression\nGZIP - tar.gz using gzip compression\nBZIP2 - tar.bz2 archive using bzip2 compression\nLZMA - tar.xz using lzma compression\nTAR - .tar with no compression\n")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Category(value="Create")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public ArchiveFormat format = ArchiveFormat.ZIP;
    @Comment(value="\nMinimal permission level required to run commands\n")
    @ConfigEntry.Category(value="Manage")
    @ConfigEntry.Gui.NoTooltip
    public int permissionLevel = 4;
    @Comment(value="\nPlayer on singleplayer is always allowed to run command. Warning! On lan party everyone will be allowed to run it.\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Manage")
    public boolean alwaysSingleplayerAllowed = true;
    @Comment(value="\nPlayers allowed to run backup commands without sufficient permission level\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Manage")
    public List<String> playerWhitelist = new ArrayList<String>();
    @Comment(value="\nPlayers banned from running backup commands besides their sufficient permission level\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Manage")
    public List<String> playerBlacklist = new ArrayList<String>();
    @Comment(value="\nAnnounce to ALL players when backup starts\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Manage")
    public boolean broadcastBackupStart = true;
    @Comment(value="\nAnnounce to ALL players when backup finishes\n")
    @ConfigEntry.Gui.NoTooltip
    @ConfigEntry.Category(value="Manage")
    public boolean broadcastBackupDone = true;
    @Comment(value="\nFormat of date&time used to name backup files.\nRemember not to use '#' symbol or any other character that is not allowed by your operating system such as:\n':', '\\', etc...\nFor more info: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html\n")
    @ConfigEntry.Gui.Tooltip
    public String dateTimeFormat = "yyyy.MM.dd_HH-mm-ss";

    public void validatePostLoad() throws ConfigData.ValidationException {
        if (this.compressionCoreCountLimit > Runtime.getRuntime().availableProcessors()) {
            throw new ConfigData.ValidationException("compressionCoreCountLimit is too high! Your system only has: " + Runtime.getRuntime().availableProcessors() + " cores!");
        }
        try {
            DateTimeFormatter.ofPattern(this.dateTimeFormat);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigData.ValidationException("dateTimeFormat is wrong! See: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html", (Throwable)e);
        }
    }

    public static enum ArchiveFormat {
        ZIP("zip"),
        GZIP("tar", "gz"),
        BZIP2("tar", "bz2"),
        LZMA("tar", "xz"),
        TAR("tar");

        private final List<String> extensionPieces;

        private ArchiveFormat(String ... extensionParts) {
            this.extensionPieces = Arrays.asList(extensionParts);
        }

        public String getCompleteString() {
            StringBuilder builder = new StringBuilder();
            this.extensionPieces.forEach(s -> builder.append('.').append((String)s));
            return builder.toString();
        }

        boolean isMultipart() {
            return this.extensionPieces.size() > 1;
        }

        public String getLastPiece() {
            return this.extensionPieces.get(this.extensionPieces.size() - 1);
        }
    }
}

