/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.commands.manage;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.config.ConfigHelper;

public class WhitelistCommand {
    private static final TextileLogger log = new TextileLogger("Textile Backup");
    private static final ConfigHelper config = ConfigHelper.INSTANCE;

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"whitelist").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(WhitelistCommand::executeAdd)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(WhitelistCommand::executeRemove)))).then(class_2170.method_9247((String)"list").executes(ctx -> WhitelistCommand.executeList((class_2168)ctx.getSource())))).executes(ctx -> WhitelistCommand.help((class_2168)ctx.getSource()));
    }

    private static int help(class_2168 source) {
        log.sendInfo(source, "Available command are: add [player], remove [player], list.", new Object[0]);
        return 1;
    }

    private static int executeList(class_2168 source) {
        StringBuilder builder = new StringBuilder();
        builder.append("Currently on the whitelist are: ");
        for (String name : WhitelistCommand.config.get().playerWhitelist) {
            builder.append(name);
            builder.append(", ");
        }
        log.sendInfo(source, builder.toString(), new Object[0]);
        return 1;
    }

    private static int executeAdd(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(ctx, (String)"player");
        if (WhitelistCommand.config.get().playerWhitelist.contains(player.method_5820())) {
            log.sendInfo((class_2168)ctx.getSource(), "Player: {} is already whitelisted.", player.method_5820());
        } else {
            WhitelistCommand.config.get().playerWhitelist.add(player.method_5820());
            config.save();
            StringBuilder builder = new StringBuilder();
            builder.append("Player: ");
            builder.append(player.method_5820());
            builder.append(" added to the whitelist");
            if (WhitelistCommand.config.get().playerBlacklist.contains(player.method_5820())) {
                WhitelistCommand.config.get().playerBlacklist.remove(player.method_5820());
                config.save();
                builder.append(" and removed form the blacklist");
            }
            builder.append(" successfully.");
            ((class_2168)ctx.getSource()).method_9211().method_3734().method_9241(player);
            log.sendInfo((class_2168)ctx.getSource(), builder.toString(), new Object[0]);
        }
        return 1;
    }

    private static int executeRemove(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(ctx, (String)"player");
        if (!WhitelistCommand.config.get().playerWhitelist.contains(player.method_5820())) {
            log.sendInfo((class_2168)ctx.getSource(), "Player: {} newer was whitelisted.", player.method_5820());
        } else {
            WhitelistCommand.config.get().playerWhitelist.remove(player.method_5820());
            config.save();
            ((class_2168)ctx.getSource()).method_9211().method_3734().method_9241(player);
            log.sendInfo((class_2168)ctx.getSource(), "Player: {} removed from the whitelist successfully.", player.method_5820());
        }
        return 1;
    }
}

