/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.commands.manage;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.szum123321.textile_backup.Statics;
import net.szum123321.textile_backup.TextileLogger;
import net.szum123321.textile_backup.commands.CommandExceptions;
import net.szum123321.textile_backup.commands.FileSuggestionProvider;
import net.szum123321.textile_backup.core.Utilities;

public class DeleteCommand {
    private static final TextileLogger log = new TextileLogger("Textile Backup");

    public static LiteralArgumentBuilder<class_2168> register() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"file", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)FileSuggestionProvider.Instance()).executes(ctx -> DeleteCommand.execute((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"file"))));
    }

    private static int execute(class_2168 source, String fileName) throws CommandSyntaxException {
        LocalDateTime dateTime;
        try {
            dateTime = LocalDateTime.from(Statics.defaultDateTimeFormatter.parse(fileName));
        }
        catch (DateTimeParseException e) {
            throw CommandExceptions.DATE_TIME_PARSE_COMMAND_EXCEPTION_TYPE.create((Object)e);
        }
        File root = Utilities.getBackupRootPath(Utilities.getLevelName(source.method_9211()));
        Optional<File> optionalFile = Arrays.stream(root.listFiles()).filter(Utilities::isValidBackup).filter(file -> Utilities.getFileCreationTime(file).orElse(LocalDateTime.MIN).equals(dateTime)).findFirst();
        if (optionalFile.isPresent()) {
            if (Statics.untouchableFile.isEmpty() || !Statics.untouchableFile.get().equals(optionalFile.get())) {
                if (optionalFile.get().delete()) {
                    log.sendInfo(source, "File {} successfully deleted!", optionalFile.get().getName());
                    if (source.method_9228() instanceof class_1657) {
                        log.info("Player {} deleted {}.", source.method_9207().method_5477(), optionalFile.get().getName());
                    }
                } else {
                    log.sendError(source, "Something went wrong while deleting file!", new Object[0]);
                }
            } else {
                log.sendError(source, "Couldn't delete the file because it's being restored right now.", new Object[0]);
                log.sendHint(source, "If you want to abort restoration then use: /backup killR", new Object[0]);
            }
        } else {
            log.sendError(source, "Couldn't find file by this name.", new Object[0]);
            log.sendHint(source, "Maybe try /backup list", new Object[0]);
        }
        return 0;
    }
}

