/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup.commands;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.szum123321.textile_backup.Statics;
import net.szum123321.textile_backup.core.restore.RestoreHelper;

public final class FileSuggestionProvider
implements SuggestionProvider<class_2168> {
    private static final FileSuggestionProvider INSTANCE = new FileSuggestionProvider();

    public static FileSuggestionProvider Instance() {
        return INSTANCE;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        String remaining = builder.getRemaining();
        for (RestoreHelper.RestoreableFile file : RestoreHelper.getAvailableBackups(((class_2168)ctx.getSource()).method_9211())) {
            String formattedCreationTime = file.getCreationTime().format(Statics.defaultDateTimeFormatter);
            if (!formattedCreationTime.startsWith(remaining)) continue;
            if (((class_2168)ctx.getSource()).method_9228() instanceof class_1657) {
                if (file.getComment() != null) {
                    builder.suggest(formattedCreationTime, (Message)new LiteralMessage("Comment: " + file.getComment()));
                    continue;
                }
                builder.suggest(formattedCreationTime);
                continue;
            }
            if (file.getComment() != null) {
                builder.suggest(file.getCreationTime() + "#" + file.getComment());
                continue;
            }
            builder.suggest(formattedCreationTime);
        }
        return builder.buildFuture();
    }
}

