/*
 * Decompiled with CFR 0.152.
 */
package net.szum123321.textile_backup;

import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;
import net.szum123321.textile_backup.core.create.BackupContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.util.StackLocatorUtil;

public class TextileLogger {
    private final MessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
    private final Logger logger = LogManager.getLogger((Class)StackLocatorUtil.getCallerClass((int)2), (MessageFactory)this.messageFactory);
    private final String prefix;
    private final class_5250 prefixText;

    public TextileLogger(String prefix) {
        this.prefix = "[" + prefix + "] ";
        this.prefixText = new class_2585(this.prefix).method_27694(style -> style.method_36139(5972954));
    }

    public class_5250 getPrefixText() {
        return this.prefixText.method_27661();
    }

    public void log(Level level, String msg, Object ... data) {
        this.logger.log(level, this.prefix + msg, data);
    }

    public void trace(String msg, Object ... data) {
        this.log(Level.TRACE, msg, data);
    }

    public void debug(String msg, Object ... data) {
        this.log(Level.DEBUG, msg, data);
    }

    public void info(String msg, Object ... data) {
        this.log(Level.INFO, msg, data);
    }

    public void warn(String msg, Object ... data) {
        this.log(Level.WARN, msg, data);
    }

    public void error(String msg, Object ... data) {
        this.log(Level.ERROR, msg, data);
    }

    public void fatal(String msg, Object ... data) {
        this.log(Level.FATAL, msg, data);
    }

    boolean sendFeedback(Level level, class_2168 source, String msg, Object ... args) {
        if (source != null && source.method_9228() instanceof class_1657) {
            class_2585 text = new class_2585(this.messageFactory.newMessage(msg, args).getFormattedMessage());
            if (level.intLevel() == Level.TRACE.intLevel()) {
                text.method_27692(class_124.field_1060);
            } else if (level.intLevel() <= Level.WARN.intLevel()) {
                text.method_27692(class_124.field_1061);
            } else {
                text.method_27692(class_124.field_1068);
            }
            source.method_9226((class_2561)this.prefixText.method_27661().method_10852((class_2561)text), false);
            return true;
        }
        this.log(level, msg, args);
        return false;
    }

    public void sendHint(class_2168 source, String msg, Object ... args) {
        this.sendFeedback(Level.TRACE, source, msg, args);
    }

    public void sendInfo(class_2168 source, String msg, Object ... args) {
        this.sendFeedback(Level.INFO, source, msg, args);
    }

    public void sendInfo(BackupContext context, String msg, Object ... args) {
        this.sendInfo(context.getCommandSource(), msg, args);
    }

    public void sendError(class_2168 source, String msg, Object ... args) {
        this.sendFeedback(Level.ERROR, source, msg, args);
    }

    public void sendError(BackupContext context, String msg, Object ... args) {
        this.sendError(context.getCommandSource(), msg, args);
    }

    public void sendToPlayerAndLog(Level level, class_2168 source, String msg, Object ... args) {
        if (this.sendFeedback(level, source, msg, args)) {
            this.log(level, msg, args);
        }
    }

    public void sendInfoAL(class_2168 source, String msg, Object ... args) {
        this.sendToPlayerAndLog(Level.INFO, source, msg, args);
    }

    public void sendInfoAL(BackupContext context, String msg, Object ... args) {
        this.sendInfoAL(context.getCommandSource(), msg, args);
    }

    public void sendErrorAL(class_2168 source, String msg, Object ... args) {
        this.sendToPlayerAndLog(Level.ERROR, source, msg, args);
    }

    public void sendErrorAL(BackupContext context, String msg, Object ... args) {
        this.sendErrorAL(context.getCommandSource(), msg, args);
    }
}

