/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.mod.registration;

import com.google.common.collect.ImmutableList;
import io.github.noeppi_noeppi.libx.impl.registration.BuiltinTransformers;
import io.github.noeppi_noeppi.libx.mod.registration.RegistryCondition;
import io.github.noeppi_noeppi.libx.mod.registration.RegistryTransformer;
import java.util.ArrayList;
import java.util.List;

public class RegistrationBuilder {
    private int version = -1;
    private final List<RegistryCondition> customConditions = new ArrayList<RegistryCondition>();
    private final List<RegistryTransformer> customTransformers = new ArrayList<RegistryTransformer>();

    RegistrationBuilder() {
    }

    public void setVersion(int version) {
        if (this.version >= 0) {
            throw new IllegalStateException("LibX registration version set twice.");
        }
        this.version = version;
    }

    public void addCondition(RegistryCondition condition) {
        this.customConditions.add(condition);
    }

    public void addTransformer(RegistryTransformer transformer) {
        this.customTransformers.add(transformer);
    }

    public RegistrationSettings build() {
        if (this.version < 0) {
            throw new IllegalStateException("LibX registration version not set.");
        }
        ImmutableList.Builder conditions = ImmutableList.builder();
        ImmutableList.Builder replacers = ImmutableList.builder();
        ImmutableList.Builder transformers = ImmutableList.builder();
        switch (this.version) {
            case 1: {
                replacers.add((Object)BuiltinTransformers.DATA_SERIALIZER);
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown LibX registration version: " + this.version);
            }
        }
        conditions.addAll(this.customConditions);
        transformers.addAll(this.customTransformers);
        return new RegistrationSettings((List<RegistryCondition>)conditions.build(), (List<RegistryTransformer>)replacers.build(), (List<RegistryTransformer>)transformers.build());
    }

    public record RegistrationSettings(List<RegistryCondition> conditions, List<RegistryTransformer> replacers, List<RegistryTransformer> transformers) {
    }
}

