/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config.gui.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.noeppi_noeppi.libx.config.ValidatorInfo;
import io.github.noeppi_noeppi.libx.config.gui.ConfigEditor;
import io.github.noeppi_noeppi.libx.config.gui.InputProperties;
import io.github.noeppi_noeppi.libx.config.gui.WidgetProperties;
import io.github.noeppi_noeppi.libx.render.RenderHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class InputEditor<T>
implements ConfigEditor<T> {
    private final InputProperties<T> properties;
    private final ValidatorInfo<?> validator;

    public InputEditor(InputProperties<T> properties, ValidatorInfo<?> validator) {
        this.properties = properties;
        this.validator = validator;
    }

    @Override
    public T defaultValue() {
        return this.properties.defaultValue();
    }

    @Override
    public AbstractWidget createWidget(Screen screen, T initialValue, WidgetProperties<T> properties) {
        return new InputWidget<T>(this.properties, this.validator, initialValue, properties);
    }

    @Override
    public AbstractWidget updateWidget(Screen screen, AbstractWidget old, WidgetProperties<T> properties) {
        if (old instanceof InputWidget) {
            return new InputWidget<T>(this.properties, this.validator, (InputWidget)old, properties);
        }
        return this.createWidget(screen, this.defaultValue(), properties);
    }

    public static class InputWidget<T>
    extends EditBox {
        private final InputProperties<T> input;
        private final ValidatorInfo<?> validator;
        private String last = null;

        private InputWidget(InputProperties<T> input, ValidatorInfo<?> validator, WidgetProperties<T> properties, String initialValue) {
            super(Minecraft.m_91087_().f_91062_, properties.x(), properties.y(), properties.width(), properties.height(), (Component)new TextComponent(""));
            this.input = input;
            this.validator = validator;
            this.m_94199_(Short.MAX_VALUE);
            this.m_94144_(initialValue);
            this.m_94153_(str -> {
                for (char chr : str.toCharArray()) {
                    if (this.input.canInputChar(chr)) continue;
                    return false;
                }
                return true;
            });
            this.m_94151_(str -> {
                if (this.last == null || !this.last.equals(str)) {
                    this.last = str;
                    if (this.input.isValid((String)str)) {
                        properties.inputChanged().accept(this.input.valueOf((String)str));
                    }
                }
            });
        }

        public InputWidget(InputProperties<T> input, ValidatorInfo<?> validator, T initialValue, WidgetProperties<T> properties) {
            this(input, validator, properties, input.toString(initialValue));
        }

        public InputWidget(InputProperties<T> input, ValidatorInfo<?> validator, InputWidget<T> old, WidgetProperties<T> properties) {
            this(input, validator, properties, old.m_94155_());
        }

        public Optional<T> getValidInput() {
            return this.getValidInput(this.m_94155_());
        }

        private Optional<T> getValidInput(String str) {
            T t;
            if (this.input.isValid(str) && this.validator.isValid(t = this.input.valueOf(str))) {
                return Optional.of(t);
            }
            return Optional.empty();
        }

        public void m_6303_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.m_6303_(poseStack, mouseX, mouseY, partialTicks);
            if (this.m_94213_() && this.getValidInput(this.m_94155_()).isEmpty()) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 10.0);
                RenderSystem.m_157456_((int)0, (ResourceLocation)RenderHelper.TEXTURE_WHITE);
                RenderHelper.rgb(0xFF2222);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (float)0.0f, (float)0.0f, (int)(this.f_93618_ + 2), (int)1, (int)256, (int)256);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ + this.f_93619_), (float)0.0f, (float)0.0f, (int)(this.f_93618_ + 2), (int)1, (int)256, (int)256);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (float)0.0f, (float)0.0f, (int)1, (int)(this.f_93619_ + 2), (int)256, (int)256);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ - 1), (float)0.0f, (float)0.0f, (int)1, (int)(this.f_93619_ + 2), (int)256, (int)256);
                RenderHelper.resetColor();
                poseStack.m_85849_();
            }
        }
    }
}

