/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.data.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.noeppi_noeppi.libx.data.LootBuilders;
import io.github.noeppi_noeppi.libx.impl.data.LootData;
import io.github.noeppi_noeppi.libx.mod.ModX;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EntityLootProviderBase
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final ModX mod;
    protected final DataGenerator generator;
    private final Map<EntityType<?>, Function<EntityType<?>, LootTable.Builder>> functionMap = new HashMap();

    public EntityLootProviderBase(ModX mod, DataGenerator generator) {
        this.mod = mod;
        this.generator = generator;
    }

    protected void customLootTable(EntityType<?> entity, LootTable.Builder loot) {
        this.functionMap.put(entity, b -> loot);
    }

    protected void customLootTable(EntityType<?> entity, Function<EntityType<?>, LootTable.Builder> loot) {
        this.functionMap.put(entity, loot);
    }

    @Nonnull
    public final String m_6055_() {
        return this.mod.modid + " entity loot tables";
    }

    public void m_6865_(@Nonnull HashCache cache) throws IOException {
        this.setup();
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        for (ResourceLocation resourceLocation : ForgeRegistries.ENTITIES.getKeys()) {
            Function<EntityType<?>, LootTable.Builder> loot;
            EntityType entity = (EntityType)ForgeRegistries.ENTITIES.getValue(resourceLocation);
            if (entity == null || !this.mod.modid.equals(resourceLocation.m_135827_())) continue;
            if (this.functionMap.containsKey(entity)) {
                loot = this.functionMap.get(entity);
            } else {
                LootTable.Builder builder = this.defaultBehavior(entity);
                Function<EntityType, LootTable.Builder> function = loot = builder == null ? null : b -> builder;
            }
            if (loot == null) continue;
            tables.put(resourceLocation, loot.apply(entity));
        }
        for (Map.Entry entry : tables.entrySet()) {
            Path path = EntityLootProviderBase.getPath(this.generator.m_123916_(), (ResourceLocation)entry.getKey());
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)((LootTable.Builder)entry.getValue()).m_79165_(LootContextParamSets.f_81415_).m_79167_()), (Path)path);
        }
    }

    protected abstract void setup();

    private static Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.m_135827_() + "/loot_tables/entities/" + id.m_135815_() + ".json");
    }

    public void drops(EntityType<?> e, ItemStack ... drops) {
        LootFactory[] loot = new LootFactory[drops.length];
        for (int i = 0; i < drops.length; ++i) {
            loot[i] = this.stack(drops[i]);
        }
        this.drops(e, loot);
    }

    public void drops(EntityType<?> e, LootPoolEntryContainer.Builder<?> ... loot) {
        this.drops(e, LootFactory.from(loot));
    }

    public void drops(EntityType<?> e, LootFactory ... loot) {
        LootPoolEntryContainer.Builder<?> entry = this.combine(LootFactory.resolve(e, loot));
        LootPool.Builder pool = LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(entry);
        this.customLootTable(e, LootTable.m_79147_().m_79161_(pool));
    }

    public LootFactory repeat(LootFactory factory, int times) {
        LootFactory[] factories = new LootFactory[times];
        for (int i = 0; i < times; ++i) {
            factories[i] = factory;
        }
        return this.combine(factories);
    }

    public WrappedLootEntry from(LootPoolSingletonContainer.Builder<?> entry) {
        return new WrappedLootEntry(entry);
    }

    public LootFactory from(LootPoolEntryContainer.Builder<?> entry) {
        return LootFactory.from(entry);
    }

    public LootModifier from(LootItemConditionalFunction.Builder<?> function) {
        return (e, b) -> b.m_5577_((LootItemFunction.Builder)function);
    }

    public LootModifier looting(int max) {
        return this.looting(0, max);
    }

    public LootModifier looting(int min, int max) {
        return (e, b) -> b.m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    public LootItemCondition.Builder random(float chance) {
        return LootItemRandomChanceCondition.m_81927_((float)chance);
    }

    public LootModifier count(int count) {
        return this.from(SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count)));
    }

    public LootModifier count(int min, int max) {
        if (min == max) {
            return this.from(SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)min)));
        }
        return this.from(SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
    }

    public LootModifier countBinomial(float chance, int num) {
        return this.from(SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)num, (float)chance)));
    }

    public LootItemCondition.Builder not(LootItemCondition.Builder condition) {
        return InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)condition);
    }

    public LootItemCondition.Builder or(LootItemCondition.Builder ... conditions) {
        return AlternativeLootItemCondition.m_81481_((LootItemCondition.Builder[])conditions);
    }

    public LootPoolEntryContainer.Builder<?> combine(LootPoolEntryContainer.Builder<?> ... loot) {
        return LootData.combineBy(LootBuilders::all, loot);
    }

    public LootFactory combine(LootFactory ... loot) {
        return e -> LootData.combineBy(LootBuilders::all, l -> l.build(e), loot);
    }

    public LootPoolEntryContainer.Builder<?> random(LootPoolEntryContainer.Builder<?> ... loot) {
        return LootData.combineBy(LootBuilders::group, loot);
    }

    public LootFactory random(LootFactory ... loot) {
        return e -> LootData.combineBy(LootBuilders::group, l -> l.build(e), loot);
    }

    public LootPoolEntryContainer.Builder<?> first(LootPoolEntryContainer.Builder<?> ... loot) {
        return LootData.combineBy(LootBuilders::alternative, loot);
    }

    public LootFactory first(LootFactory ... loot) {
        return e -> LootData.combineBy(LootBuilders::alternative, l -> l.build(e), loot);
    }

    public LootPoolEntryContainer.Builder<?> whileMatch(LootPoolEntryContainer.Builder<?> ... loot) {
        return LootData.combineBy(LootBuilders::sequence, loot);
    }

    public LootFactory whileMatch(LootFactory ... loot) {
        return e -> LootData.combineBy(LootBuilders::sequence, l -> l.build(e), loot);
    }

    public WrappedLootEntry stack(ItemLike item) {
        return new WrappedLootEntry(LootItem.m_79579_((ItemLike)item));
    }

    public WrappedLootEntry stack(ItemStack stack) {
        return new WrappedLootEntry(LootData.stack(stack));
    }

    @Nullable
    protected LootTable.Builder defaultBehavior(EntityType<?> e) {
        return null;
    }

    @FunctionalInterface
    public static interface LootFactory {
        public static LootFactory from(LootPoolEntryContainer.Builder<?> builder) {
            return b -> builder;
        }

        public static LootFactory[] from(LootPoolEntryContainer.Builder<?>[] builders) {
            LootFactory[] factories = new LootFactory[builders.length];
            for (int i = 0; i < builders.length; ++i) {
                LootPoolEntryContainer.Builder<?> builder = builders[i];
                factories[i] = b -> builder;
            }
            return factories;
        }

        public static LootPoolEntryContainer.Builder<?>[] resolve(EntityType<?> e, LootFactory[] factories) {
            LootPoolEntryContainer.Builder[] entries = new LootPoolEntryContainer.Builder[factories.length];
            for (int i = 0; i < factories.length; ++i) {
                entries[i] = factories[i].build(e);
            }
            return entries;
        }

        public LootPoolEntryContainer.Builder<?> build(EntityType<?> var1);

        default public LootFactory with(LootItemCondition.Builder ... conditions) {
            return e -> {
                LootPoolEntryContainer.Builder<?> entry = this.build(e);
                for (LootItemCondition.Builder condition : conditions) {
                    entry.m_6509_(condition);
                }
                return entry;
            };
        }
    }

    public static class WrappedLootEntry
    implements SimpleLootFactory {
        public final LootPoolSingletonContainer.Builder<?> entry;

        private WrappedLootEntry(LootPoolSingletonContainer.Builder<?> entry) {
            this.entry = entry;
        }

        @Override
        public LootPoolSingletonContainer.Builder<?> build(EntityType<?> entity) {
            return this.entry;
        }
    }

    @FunctionalInterface
    public static interface LootModifier
    extends GenericLootModifier {
        public static LootModifier identity() {
            return (e, b) -> b;
        }

        public static LootModifier chain(LootModifier ... children) {
            if (children.length == 0) {
                return LootModifier.identity();
            }
            if (children.length == 1) {
                return children[0];
            }
            return (b, e) -> {
                LootPoolSingletonContainer.Builder<?> entry = e;
                for (LootModifier modifier : children) {
                    entry = modifier.apply((EntityType<?>)b, entry);
                }
                return entry;
            };
        }

        public LootPoolSingletonContainer.Builder<?> apply(EntityType<?> var1, LootPoolSingletonContainer.Builder<?> var2);

        default public LootModifier andThen(LootModifier other) {
            return LootModifier.chain(this, other);
        }
    }

    @FunctionalInterface
    public static interface GenericLootModifier {
        public static GenericLootModifier identity() {
            return (e, b) -> b;
        }

        public LootPoolEntryContainer.Builder<?> apply(EntityType<?> var1, LootPoolSingletonContainer.Builder<?> var2);
    }

    @FunctionalInterface
    public static interface SimpleLootFactory
    extends LootFactory {
        public static SimpleLootFactory from(LootPoolSingletonContainer.Builder<?> builder) {
            return b -> builder;
        }

        public static SimpleLootFactory[] from(LootPoolSingletonContainer.Builder<?>[] builders) {
            SimpleLootFactory[] factories = new SimpleLootFactory[builders.length];
            for (int i = 0; i < builders.length; ++i) {
                LootPoolSingletonContainer.Builder<?> builder = builders[i];
                factories[i] = e -> builder;
            }
            return factories;
        }

        public static LootPoolSingletonContainer.Builder<?>[] resolve(EntityType<?> e, SimpleLootFactory[] factories) {
            LootPoolSingletonContainer.Builder[] entries = new LootPoolSingletonContainer.Builder[factories.length];
            for (int i = 0; i < factories.length; ++i) {
                entries[i] = factories[i].build(e);
            }
            return entries;
        }

        public LootPoolSingletonContainer.Builder<?> build(EntityType<?> var1);

        default public LootFactory withFinal(GenericLootModifier finalModifier) {
            return e -> finalModifier.apply(e, this.build((EntityType<?>)e));
        }

        default public SimpleLootFactory with(LootModifier ... modifiers) {
            LootModifier chained = LootModifier.chain(modifiers);
            return e -> chained.apply((EntityType<?>)e, this.build((EntityType<?>)e));
        }

        @Override
        default public SimpleLootFactory with(LootItemCondition.Builder ... conditions) {
            return e -> {
                LootPoolSingletonContainer.Builder<?> entry = this.build((EntityType<?>)e);
                for (LootItemCondition.Builder condition : conditions) {
                    entry.m_6509_(condition);
                }
                return entry;
            };
        }

        default public SimpleLootFactory with(LootItemConditionalFunction.Builder<?> ... functions) {
            LootModifier[] modifiers = new LootModifier[functions.length];
            for (int i = 0; i < functions.length; ++i) {
                LootItemConditionalFunction.Builder<?> function = functions[i];
                modifiers[i] = (e, b) -> b.m_5577_((LootItemFunction.Builder)function);
            }
            LootModifier chained = LootModifier.chain(modifiers);
            return e -> chained.apply((EntityType<?>)e, this.build((EntityType<?>)e));
        }
    }
}

