/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class MergedIngredient
extends Ingredient {
    private final List<Ingredient> ingredients;

    protected MergedIngredient(List<Ingredient> ingredients) {
        super(Stream.empty());
        this.ingredients = ImmutableList.copyOf(ingredients);
    }

    public static Ingredient mergeIngredients(Ingredient ... ingredients) {
        return MergedIngredient.mergeIngredients(Arrays.asList(ingredients));
    }

    public static Ingredient mergeIngredients(List<Ingredient> ingredients) {
        if (ingredients.isEmpty()) {
            return Ingredient.f_43901_;
        }
        if (ingredients.size() == 1) {
            return ingredients.get(0);
        }
        if (ingredients.stream().allMatch(Ingredient::isVanilla)) {
            return Ingredient.m_43938_(ingredients.stream().flatMap(i -> Arrays.stream(i.f_43902_)));
        }
        if (ingredients.stream().anyMatch(Ingredient::isVanilla)) {
            Ingredient vanilla = Ingredient.m_43938_(ingredients.stream().filter(Ingredient::isVanilla).flatMap(i -> Arrays.stream(i.f_43902_)));
            ArrayList<Ingredient> list = new ArrayList<Ingredient>();
            list.add(vanilla);
            ingredients.stream().filter(i -> !i.isVanilla()).forEach(list::add);
            return new MergedIngredient(list);
        }
        return new MergedIngredient(ingredients);
    }

    public List<Ingredient> getIngredients() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        return (ItemStack[])this.ingredients.stream().flatMap(i -> Arrays.stream(i.m_43908_())).toArray(ItemStack[]::new);
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.ingredients.stream().anyMatch(i -> i.test(stack));
    }

    @Nonnull
    public IntList m_43931_() {
        IntArrayList ial = new IntArrayList();
        for (Ingredient i : this.ingredients) {
            ial.addAll(i.m_43931_());
        }
        return ial;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean m_43947_() {
        return this.ingredients.stream().allMatch(Ingredient::m_43947_);
    }

    @Nonnull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        JsonArray array = new JsonArray();
        for (Ingredient i : this.ingredients) {
            array.add(i.m_43942_());
        }
        json.add("ingredients", (JsonElement)array);
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<MergedIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Nonnull
        public MergedIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            ArrayList<Ingredient> list = new ArrayList<Ingredient>();
            for (int i = 0; i < size; ++i) {
                list.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            return new MergedIngredient(list);
        }

        @Nonnull
        public MergedIngredient parse(JsonObject json) {
            JsonArray array = json.get("ingredients").getAsJsonArray();
            ArrayList<Ingredient> list = new ArrayList<Ingredient>();
            for (JsonElement elem : array) {
                list.add(Ingredient.m_43917_((JsonElement)elem));
            }
            return new MergedIngredient(list);
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull MergedIngredient ingredient) {
            buffer.m_130130_(ingredient.ingredients.size());
            for (Ingredient i : ingredient.ingredients) {
                i.m_43923_(buffer);
            }
        }
    }
}

