/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.config.gui;

import io.github.noeppi_noeppi.libx.config.ValidatorInfo;
import io.github.noeppi_noeppi.libx.config.gui.ConfigScreenContent;
import io.github.noeppi_noeppi.libx.config.gui.InputProperties;
import io.github.noeppi_noeppi.libx.config.gui.WidgetProperties;
import io.github.noeppi_noeppi.libx.impl.config.gui.editor.CustomEditor;
import io.github.noeppi_noeppi.libx.impl.config.gui.editor.InputEditor;
import io.github.noeppi_noeppi.libx.impl.config.gui.editor.OptionEditor;
import io.github.noeppi_noeppi.libx.impl.config.gui.editor.SimpleSelectEditor;
import io.github.noeppi_noeppi.libx.impl.config.gui.editor.SliderEditor;
import io.github.noeppi_noeppi.libx.impl.config.gui.editor.UnsupportedEditor;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.content.SelectContent;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public interface ConfigEditor<T> {
    public T defaultValue();

    public AbstractWidget createWidget(Screen var1, T var2, WidgetProperties<T> var3);

    public AbstractWidget updateWidget(Screen var1, AbstractWidget var2, WidgetProperties<T> var3);

    public static <T> ConfigEditor<T> unsupported(T defaultValue) {
        return new UnsupportedEditor<T>(defaultValue);
    }

    public static <T> ConfigEditor<Optional<T>> option(ConfigEditor<T> editor) {
        return new OptionEditor<T>(editor);
    }

    public static <T> ConfigEditor<T> toggle(List<T> elems) {
        return ConfigEditor.toggle(elems, e -> new TextComponent(e.toString()));
    }

    public static <T> ConfigEditor<T> toggle(List<T> elems, Function<T, Component> name) {
        if (elems.size() <= 5) {
            return new SimpleSelectEditor<T>(elems, name);
        }
        return ConfigEditor.custom(elems.get(0), current -> new SelectContent<Object>(elems, name, current));
    }

    public static ConfigEditor<String> input() {
        return ConfigEditor.input(InputProperties.PLAIN, ValidatorInfo.empty());
    }

    public static ConfigEditor<String> input(ValidatorInfo<?> validator) {
        return ConfigEditor.input(InputProperties.PLAIN, validator);
    }

    public static <T> ConfigEditor<T> input(InputProperties<T> input) {
        return ConfigEditor.input(input, ValidatorInfo.empty());
    }

    public static <T> ConfigEditor<T> input(InputProperties<T> input, ValidatorInfo<?> validator) {
        return new InputEditor<T>(input, validator);
    }

    public static <T> ConfigEditor<T> slider(Function<T, Double> extractor, Function<Double, T> factory) {
        return new SliderEditor<T>(extractor, factory);
    }

    public static <T> ConfigEditor<T> custom(T defaultValue, Function<T, ConfigScreenContent<T>> contentFactory) {
        return new CustomEditor<T>(defaultValue, contentFactory);
    }
}

