/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.capability;

import io.github.noeppi_noeppi.libx.inventory.IAdvancedItemHandlerModifiable;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemCapabilities {
    public static LazyOptional<IAdvancedItemHandlerModifiable> create(IItemHandlerModifiable handler) {
        return ItemCapabilities.create(() -> handler);
    }

    public static LazyOptional<IAdvancedItemHandlerModifiable> create(IItemHandlerModifiable handler, @Nullable Predicate<Integer> extract, @Nullable BiPredicate<Integer, ItemStack> insert) {
        return ItemCapabilities.create(() -> handler, extract, insert);
    }

    public static LazyOptional<IAdvancedItemHandlerModifiable> create(Supplier<IItemHandlerModifiable> handler) {
        return LazyOptional.of(() -> IAdvancedItemHandlerModifiable.wrap((IItemHandlerModifiable)handler.get()));
    }

    public static LazyOptional<IAdvancedItemHandlerModifiable> create(Supplier<IItemHandlerModifiable> handler, @Nullable Predicate<Integer> extract, @Nullable BiPredicate<Integer, ItemStack> insert) {
        return LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)handler.get(), extract == null ? slot -> true : extract, insert == null ? (slot, stack) -> true : insert));
    }

    private static class WrappedHandler
    implements IAdvancedItemHandlerModifiable {
        private final IItemHandlerModifiable handler;
        private final Predicate<Integer> extract;
        private final BiPredicate<Integer, ItemStack> insert;

        public WrappedHandler(IItemHandlerModifiable handler, Predicate<Integer> extract, BiPredicate<Integer, ItemStack> insert) {
            this.handler = handler;
            this.extract = extract;
            this.insert = insert;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.handler.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.handler.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.handler.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.insert.test(slot, stack) ? this.handler.insertItem(slot, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.extract.test(slot) ? this.handler.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.handler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.insert.test(slot, stack) && this.handler.isItemValid(slot, stack);
        }
    }
}

