/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.base.tile;

import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.LibX;
import io.github.noeppi_noeppi.libx.impl.BlockEntityUpdateQueue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class BlockEntityBase
extends BlockEntity {
    private final Set<Capability<?>> caps;

    public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, new Capability[0]);
    }

    public BlockEntityBase(BlockEntityType<?> type, BlockPos pos, BlockState state, Capability<?> ... caps) {
        super(type, pos, state);
        this.caps = ImmutableSet.copyOf((Object[])caps);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.caps.contains(cap)) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            LibX.getNetwork().requestBE(this.f_58857_, this.f_58858_);
        }
    }

    public void setDispatchable() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockEntityUpdateQueue.scheduleUpdate(this.f_58857_, this.f_58858_);
        }
    }
}

