/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor.modinit;

import io.github.noeppi_noeppi.libx.annotation.processor.Classes;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.codec.GeneratedCodec;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.config.RegisteredConfig;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.config.RegisteredMapper;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.data.DatagenEntry;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.model.LoadableModel;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.register.RegistrationEntry;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class ModInit {
    public static final List<String> DEFAULT_PARAM_CODEC_FIELDS = List.of("CODEC", "DIRECT_CODEC");
    public final String modid;
    public final Element modClass;
    private final Map<Integer, List<RegistrationEntry>> registration = new HashMap<Integer, List<RegistrationEntry>>();
    private final List<LoadableModel> models = new ArrayList<LoadableModel>();
    private final List<RegisteredMapper> configMappers = new ArrayList<RegisteredMapper>();
    private final List<RegisteredConfig> configs = new ArrayList<RegisteredConfig>();
    private final List<GeneratedCodec> codecs = new ArrayList<GeneratedCodec>();
    private final List<DatagenEntry> datagen = new ArrayList<DatagenEntry>();

    public ModInit(String modid, Element modClass, Messager messager) {
        this.modid = modid;
        this.modClass = modClass;
        if (modClass.getEnclosingElement().getKind() != ElementKind.PACKAGE || !(modClass.getEnclosingElement() instanceof PackageElement)) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Parent element of mod class is not a package", modClass);
        }
    }

    public void addRegistration(int priority, List<RegistrationEntry> entries) {
        if (!this.registration.containsKey(priority)) {
            this.registration.put(priority, new ArrayList());
        }
        List<RegistrationEntry> list = this.registration.get(priority);
        list.addAll(entries);
    }

    public void addModel(String classFqn, String fieldName, String modelNamespace, String modelPath) {
        this.models.add(new LoadableModel(classFqn, fieldName, modelNamespace.isEmpty() ? this.modid : modelNamespace, modelPath));
    }

    public void addConfigMapper(String classFqn, boolean genericType) {
        this.configMappers.add(new RegisteredMapper(classFqn, genericType));
    }

    public void addConfig(String name, boolean client, String classFqn) {
        this.configs.add(new RegisteredConfig(name, client, classFqn));
    }

    public void addCodec(GeneratedCodec codec) {
        this.codecs.add(codec);
    }

    public void addDatagen(String classFqn, List<DatagenEntry.Arg> ctorArgs) {
        this.datagen.add(new DatagenEntry(classFqn, ctorArgs));
    }

    public void write(Filer filer, Messager messager) {
        try {
            List allReg = this.registration.entrySet().stream().sorted(Comparator.comparingInt(e -> -((Integer)e.getKey()).intValue())).flatMap(e -> ((List)e.getValue()).stream()).toList();
            JavaFileObject file = filer.createSourceFile(((PackageElement)this.modClass.getEnclosingElement()).getQualifiedName() + "." + this.modClass.getSimpleName() + "$", this.modClass);
            Writer writer = file.openWriter();
            writer.write("package " + ((PackageElement)this.modClass.getEnclosingElement()).getQualifiedName() + ";");
            writer.write("@" + SuppressWarnings.class.getCanonicalName() + "({\"all\",\"unchecked\",\"rawtypes\"})");
            writer.write("public class " + this.modClass.getSimpleName() + "${");
            writer.write("private static " + Classes.sourceName("io.github.noeppi_noeppi.libx.mod.ModX") + " mod=null;");
            if (!this.codecs.isEmpty()) {
                writer.write("public static final " + Map.class.getCanonicalName() + "<Class<?>," + Classes.sourceName("com.mojang.serialization.Codec") + "<?>>codecs=buildCodecs();");
                writer.write("private static final " + Map.class.getCanonicalName() + "<Class<?>," + Classes.sourceName("com.mojang.serialization.Codec") + "<?>>buildCodecs(){");
                writer.write(Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.LazyMapBuilder") + " builder=" + Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".lazyMapBuilder();");
                for (GeneratedCodec generatedCodec : this.codecs) {
                    GeneratedCodec.CodecElement param;
                    int i;
                    writer.write("builder.put(" + generatedCodec.fqn() + ".class,");
                    writer.write("() -> " + Classes.sourceName("com.mojang.serialization.codecs.RecordCodecBuilder") + ".<" + generatedCodec.fqn() + ">create(instance->");
                    writer.write("instance.group(");
                    for (i = 0; i < generatedCodec.params().size(); ++i) {
                        param = generatedCodec.params().get(i);
                        writer.write("(");
                        param.writeCode(writer);
                        writer.write(")");
                        if (i >= generatedCodec.params().size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(").apply(instance,instance.stable(");
                    writer.write("(");
                    for (i = 0; i < generatedCodec.params().size(); ++i) {
                        param = generatedCodec.params().get(i);
                        writer.write(param.typeFqnBoxed + " ctorArg" + i);
                        if (i >= generatedCodec.params().size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(")->{");
                    writer.write("return new " + generatedCodec.fqn() + "(");
                    for (i = 0; i < generatedCodec.params().size(); ++i) {
                        writer.write("ctorArg" + i);
                        if (i >= generatedCodec.params().size() - 1) continue;
                        writer.write(",");
                    }
                    writer.write(");");
                    writer.write("}");
                    writer.write("))");
                    writer.write("));");
                }
                writer.write("return builder.build();");
                writer.write("}");
            }
            writer.write("public static void init(" + Classes.sourceName("io.github.noeppi_noeppi.libx.mod.ModX") + " mod){");
            writer.write(this.modClass.getSimpleName() + "$.mod=mod;");
            for (RegisteredMapper registeredMapper : this.configMappers) {
                writer.write(Classes.sourceName("io.github.noeppi_noeppi.libx.config.ConfigManager") + ".registerValueMapper(\"" + ModInit.quote(this.modid) + "\",new " + registeredMapper.classFqn() + (registeredMapper.genericType() ? "<>" : "") + "());");
            }
            for (RegisteredConfig registeredConfig : this.configs) {
                writer.write(Classes.sourceName("io.github.noeppi_noeppi.libx.config.ConfigManager") + ".registerConfig(" + Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".newRL(\"" + ModInit.quote(this.modid) + "\",\"" + ModInit.quote(registeredConfig.name()) + "\")," + registeredConfig.classFqn() + ".class," + registeredConfig.client() + ");");
            }
            if (!allReg.isEmpty()) {
                writer.write("((" + Classes.sourceName("io.github.noeppi_noeppi.libx.mod.registration.ModXRegistration") + ")mod).addRegistrationHandler(" + this.modClass.getSimpleName() + "$::register);");
            }
            if (!this.models.isEmpty()) {
                writer.write(Classes.sourceName("net.minecraftforge.fml.DistExecutor") + ".unsafeRunWhenOn(" + Classes.sourceName("net.minecraftforge.api.distmarker.Dist") + ".CLIENT,()->()->{");
                writer.write(Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".addModListener(" + Classes.sourceName("net.minecraftforge.client.event.ModelRegistryEvent") + ".class," + this.modClass.getSimpleName() + "$::registerModels);");
                writer.write(Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".addModListener(" + Classes.sourceName("net.minecraftforge.client.event.ModelBakeEvent") + ".class," + this.modClass.getSimpleName() + "$::bakeModels);");
                writer.write("});");
            }
            if (!this.datagen.isEmpty()) {
                writer.write(Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".addModListener(" + Classes.sourceName("net.minecraftforge.forge.event.lifecycle.GatherDataEvent") + ".class," + this.modClass.getSimpleName() + "$::gatherData);");
            }
            writer.write("}");
            if (!allReg.isEmpty()) {
                writer.write("private static void register(){");
                for (RegistrationEntry registrationEntry : allReg) {
                    writer.write("((" + Classes.sourceName("io.github.noeppi_noeppi.libx.mod.registration.ModXRegistration") + ")mod).register(\"" + ModInit.quote(registrationEntry.registryName()) + "\"," + registrationEntry.fqn() + ");");
                }
                writer.write("}");
            }
            if (!this.models.isEmpty()) {
                writer.write("@" + Classes.sourceName("net.minecraftforge.api.distmarker.OnlyIn") + "(" + Classes.sourceName("net.minecraftforge.api.distmarker.Dist") + ".CLIENT)");
                writer.write("private static void registerModels(" + Classes.sourceName("net.minecraftforge.client.event.ModelRegistryEvent") + " event){");
                for (LoadableModel loadableModel : this.models) {
                    writer.write(Classes.sourceName("net.minecraftforge.client.model.ForgeModelBakery") + ".addSpecialModel(" + Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".newRL(\"" + ModInit.quote(loadableModel.modelNamespace()) + "\",\"" + ModInit.quote(loadableModel.modelPath()) + "\"));");
                }
                writer.write("}");
                writer.write("@" + Classes.sourceName("net.minecraftforge.api.distmarker.OnlyIn") + "(" + Classes.sourceName("net.minecraftforge.api.distmarker.Dist") + ".CLIENT)");
                writer.write("private static void bakeModels(" + Classes.sourceName("net.minecraftforge.client.event.ModelBakeEvent") + " event){");
                for (LoadableModel loadableModel : this.models) {
                    writer.write(loadableModel.classFqn() + "." + ModInit.quote(loadableModel.fieldName()) + "=event.getModelRegistry().get(" + Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".newRL(\"" + ModInit.quote(loadableModel.modelNamespace()) + "\",\"" + ModInit.quote(loadableModel.modelPath()) + "\"));");
                }
                writer.write("}");
            }
            if (!this.datagen.isEmpty()) {
                writer.write("private static void gatherData(" + Classes.sourceName("net.minecraftforge.forge.event.lifecycle.GatherDataEvent") + " event){");
                for (DatagenEntry datagenEntry : this.datagen) {
                    String ctorArgs = datagenEntry.ctorArgs().stream().map(t -> switch (t) {
                        default -> throw new IncompatibleClassChangeError();
                        case DatagenEntry.Arg.MOD -> this.modClass.getSimpleName() + "$.mod";
                        case DatagenEntry.Arg.GENERATOR -> Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".getDataGenerator(event)";
                        case DatagenEntry.Arg.FILE_HELPER -> Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".getDataFileHelper(event)";
                    }).collect(Collectors.joining(","));
                    writer.write(Classes.sourceName("io.github.noeppi_noeppi.libx.annotation.impl.ProcessorInterface") + ".addDataProvider(event,new " + datagenEntry.classFqn() + "(" + ctorArgs + "));");
                }
                writer.write("}");
            }
            writer.write("}\n");
            writer.close();
        }
        catch (IOException e2) {
            messager.printMessage(Diagnostic.Kind.ERROR, "Failed to generate source code: " + e2, this.modClass);
        }
    }

    public static String quote(String str) {
        StringBuilder sb = new StringBuilder();
        for (char chr : str.toCharArray()) {
            if (chr == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (chr == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (chr == '\'') {
                sb.append("\\'");
                continue;
            }
            if (chr == '\n') {
                sb.append("\\n");
                continue;
            }
            if (chr == '\r') {
                sb.append("\\r");
                continue;
            }
            if (chr == '\t') {
                sb.append("\\t");
                continue;
            }
            if (chr == '\b') {
                sb.append("\\b");
                continue;
            }
            if (chr <= '\u001f' || chr > '\u00ff') {
                sb.append(String.format("\\u%04d", chr));
                continue;
            }
            sb.append(chr);
        }
        return sb.toString();
    }
}

