/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.tileentity;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.Lazy;
import twistedgate.immersiveposts.common.blocks.PostBaseBlock;
import twistedgate.immersiveposts.common.tileentity.IPOTileEntityBase;
import twistedgate.immersiveposts.common.tileentity.IPOTileTypes;

public class PostBaseTileEntity
extends IPOTileEntityBase {
    protected static final Lazy<BlockState> EMPTY = Lazy.of(() -> Blocks.f_50016_.m_49966_());
    @Nonnull
    protected ItemStack stack = ItemStack.f_41583_;
    @Nonnull
    protected Lazy<BlockState> coverstate = EMPTY;
    protected Direction facing = Direction.NORTH;

    public PostBaseTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)IPOTileTypes.POST_BASE.get()), pWorldPosition, pBlockState);
    }

    @Nonnull
    public ItemStack getStack() {
        return this.stack;
    }

    @Nonnull
    public BlockState getCoverState() {
        if (this.stack.m_41619_()) {
            return (BlockState)EMPTY.get();
        }
        return (BlockState)this.coverstate.get();
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        if (Direction.Plane.HORIZONTAL.test(facing)) {
            this.facing = facing;
            this.m_6596_();
        }
    }

    public boolean setStack(ItemStack stack) {
        ItemStack last = this.stack;
        if (stack == null || stack.m_41619_()) {
            this.stack = ItemStack.f_41583_;
        } else if (stack.m_41720_() instanceof BlockItem) {
            this.stack = stack;
        }
        boolean changed = !ItemStack.m_41728_((ItemStack)this.stack, (ItemStack)last);
        this.updateLazy(changed);
        if (changed) {
            this.m_6596_();
        }
        return changed;
    }

    @Override
    protected CompoundTag writeCustom(CompoundTag compound) {
        compound.m_128359_("facing", this.facing != null ? this.facing.m_122433_() : Direction.NORTH.m_122433_());
        compound.m_128365_("stack", (Tag)this.stack.serializeNBT());
        return compound;
    }

    @Override
    protected void readCustom(CompoundTag compound) {
        this.facing = Direction.m_122402_((String)compound.m_128461_("facing"));
        ItemStack last = this.stack;
        this.stack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("stack"));
        boolean changed = !ItemStack.m_41728_((ItemStack)this.stack, (ItemStack)last);
        this.updateLazy(changed);
        if (changed && this.m_58904_() != null) {
            this.m_58904_().m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean interact(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (held == ItemStack.f_41583_) {
            if (player.m_6144_() && !this.getStack().m_41619_()) {
                if (!world.f_46443_) {
                    this.setFacing(Direction.NORTH);
                    Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)this.getStack());
                    this.setStack(ItemStack.f_41583_);
                    world.m_46597_(pos, (BlockState)state.m_61124_((Property)PostBaseBlock.HIDDEN, (Comparable)Boolean.valueOf(false)));
                }
                return true;
            }
        } else if (held.m_41720_() instanceof BlockItem && this.isUsableCover(Block.m_49814_((Item)held.m_41720_()), (BlockGetter)world, pos) && this.getStack().m_41619_()) {
            if (!world.f_46443_) {
                this.setFacing(player.m_6350_().m_122424_());
                ItemStack copy = held.m_41777_();
                copy.m_41764_(1);
                this.setStack(copy);
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                    if (held.m_41619_()) {
                        player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    }
                }
                world.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)PostBaseBlock.HIDDEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PostBaseBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            }
            return true;
        }
        return false;
    }

    private boolean isUsableCover(@Nonnull Block block, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        BlockState state = block.m_49966_();
        return block != Blocks.f_50016_ && state.m_60796_(reader, pos) && state.m_60804_(reader, pos);
    }

    protected void updateLazy(boolean changed) {
        if (!changed) {
            return;
        }
        this.coverstate = this.stack == null || this.stack.m_41619_() ? EMPTY : Lazy.of(() -> {
            if (this.stack.m_41720_() instanceof BlockItem) {
                BlockState state = ((BlockItem)this.stack.m_41720_()).m_40614_().m_49966_();
                Optional<DirectionProperty> prop = state.m_61147_().stream().filter(p -> p instanceof DirectionProperty && p.m_61708_().equals("facing")).map(p -> (DirectionProperty)p).filter(p -> p.m_6908_().stream().allMatch(d -> Direction.Plane.HORIZONTAL.test(d))).findAny();
                if (prop.isPresent()) {
                    state = (BlockState)state.m_61124_((Property)prop.get(), (Comparable)this.facing);
                }
                return state;
            }
            return (BlockState)EMPTY.get();
        });
    }
}

