/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.crafting;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import twistedgate.immersiveposts.common.IPOConfig;

public class IPOConfigConditionSerializer
implements IConditionSerializer<IPOConfigCondition> {
    public static final ResourceLocation ID = new ResourceLocation("immersiveposts", "cfg");

    public void write(JsonObject json, IPOConfigCondition condition) {
        json.addProperty("key", condition.key);
        json.addProperty("value", Boolean.valueOf(condition.value));
    }

    public IPOConfigCondition read(JsonObject json) {
        String key = GsonHelper.m_13906_((JsonObject)json, (String)"key");
        boolean value = GsonHelper.m_13912_((JsonObject)json, (String)"value");
        return new IPOConfigCondition(key, value);
    }

    public ResourceLocation getID() {
        return ID;
    }

    public static class IPOConfigCondition
    implements ICondition {
        private final boolean value;
        private final String key;

        public IPOConfigCondition(String key, boolean value) {
            this.key = key;
            this.value = value;
        }

        public ResourceLocation getID() {
            return ID;
        }

        public boolean test() {
            UnmodifiableConfig cfg = IPOConfig.ALL.getValues();
            Object cfgEntry = cfg.get(this.key);
            if (cfgEntry == null) {
                cfgEntry = ((Config)cfg.get("Post Types")).get(this.key);
            }
            if (cfgEntry instanceof ForgeConfigSpec.BooleanValue) {
                Boolean cfgValue = (Boolean)((ForgeConfigSpec.BooleanValue)cfgEntry).get();
                return cfgValue != null && cfgValue == this.value;
            }
            IPOConfig.log.error("[IPOConfigCondition]: Unknown key \"{}\"", (Object)this.key);
            return false;
        }
    }
}

