/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common.blocks;

import blusunrize.immersiveengineering.api.IPostBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.IPOConfig;
import twistedgate.immersiveposts.common.IPOTags;
import twistedgate.immersiveposts.common.blocks.GenericPostBlock;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.enums.EnumFlipState;
import twistedgate.immersiveposts.enums.EnumHTrussType;
import twistedgate.immersiveposts.enums.EnumPostMaterial;
import twistedgate.immersiveposts.enums.EnumPostType;

public class PostBlock
extends GenericPostBlock
implements IPostBlock,
SimpleWaterloggedBlock {
    public static final DustParticleOptions URAN_PARTICLE = new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f);
    public static final VoxelShape POST_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    public static final VoxelShape LPARM_NORTH_BOUNDS = Shapes.m_83048_((double)0.3125, (double)0.25, (double)0.0, (double)0.6875, (double)0.75, (double)0.3125);
    public static final VoxelShape LPARM_SOUTH_BOUNDS = Shapes.m_83048_((double)0.3125, (double)0.25, (double)0.6875, (double)0.6875, (double)0.75, (double)1.0);
    public static final VoxelShape LPARM_EAST_BOUNDS = Shapes.m_83048_((double)0.6875, (double)0.25, (double)0.3125, (double)1.0, (double)0.75, (double)0.6875);
    public static final VoxelShape LPARM_WEST_BOUNDS = Shapes.m_83048_((double)0.0, (double)0.25, (double)0.3125, (double)0.3125, (double)0.75, (double)0.6875);
    public static final BooleanProperty LPARM_NORTH = BooleanProperty.m_61465_((String)"parm_north");
    public static final BooleanProperty LPARM_EAST = BooleanProperty.m_61465_((String)"parm_east");
    public static final BooleanProperty LPARM_SOUTH = BooleanProperty.m_61465_((String)"parm_south");
    public static final BooleanProperty LPARM_WEST = BooleanProperty.m_61465_((String)"parm_west");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final EnumProperty<EnumPostType> TYPE = EnumProperty.m_61587_((String)"type", EnumPostType.class);
    public static final EnumProperty<EnumFlipState> FLIPSTATE = EnumProperty.m_61587_((String)"flipstate", EnumFlipState.class);
    private static final VoxelShape X_BOUNDS = Shapes.m_83048_((double)0.0, (double)0.34375, (double)0.3125, (double)1.0, (double)1.0, (double)0.6875);
    private static final VoxelShape Z_BOUNDS = Shapes.m_83048_((double)0.3125, (double)0.34375, (double)0.0, (double)0.6875, (double)1.0, (double)1.0);
    private static final Byte2ObjectMap<VoxelShape> armMap = new Byte2ObjectArrayMap();
    private static final Byte2ObjectMap<VoxelShape> defaultMap = new Byte2ObjectArrayMap();

    public PostBlock(IPostMaterial material) {
        super(material);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(FLIPSTATE, (Comparable)((Object)EnumFlipState.UP))).m_61124_(TYPE, (Comparable)((Object)EnumPostType.POST_TOP))).m_61124_((Property)LPARM_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LPARM_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LPARM_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LPARM_WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, FLIPSTATE, TYPE, LPARM_NORTH, LPARM_EAST, LPARM_SOUTH, LPARM_WEST});
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        FluidState fs = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (((EnumPostType)((Object)state.m_61143_(TYPE))).id() > 1) {
            return state;
        }
        boolean b0 = PostBlock.canConnect((BlockGetter)world, pos, Direction.NORTH);
        boolean b1 = PostBlock.canConnect((BlockGetter)world, pos, Direction.EAST);
        boolean b2 = PostBlock.canConnect((BlockGetter)world, pos, Direction.SOUTH);
        boolean b3 = PostBlock.canConnect((BlockGetter)world, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)LPARM_NORTH, (Comparable)Boolean.valueOf(b0))).m_61124_((Property)LPARM_EAST, (Comparable)Boolean.valueOf(b1))).m_61124_((Property)LPARM_SOUTH, (Comparable)Boolean.valueOf(b2))).m_61124_((Property)LPARM_WEST, (Comparable)Boolean.valueOf(b3));
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (this.getPostMaterial() == EnumPostMaterial.URANIUM && stateIn.m_61143_(TYPE) != EnumPostType.ARM && rand.nextFloat() < 0.125f) {
            double x = (double)pos.m_123341_() + 0.375 + 0.25 * rand.nextDouble();
            double y = (double)pos.m_123342_() + rand.nextDouble();
            double z = (double)pos.m_123343_() + 0.375 + 0.25 * rand.nextDouble();
            worldIn.m_7106_((ParticleOptions)URAN_PARTICLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getPostMaterial().getItemStack();
    }

    public boolean canConnectTransformer(BlockGetter world, BlockPos pos) {
        return ((EnumPostType)((Object)world.m_8055_(pos).m_61143_(TYPE))).id() < 2;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult hit) {
        block36: {
            block38: {
                ItemStack held;
                block37: {
                    if (worldIn.f_46443_) break block36;
                    held = playerIn.m_21205_();
                    if (!IPostMaterial.isValidItem(held)) break block37;
                    if (!held.m_41656_(this.getPostMaterial().getItemStack())) {
                        playerIn.m_5661_((Component)new TranslatableComponent("immersiveposts.expectedlocal", new Object[]{this.getPostMaterial().getItemStack().m_41786_()}), true);
                        return InteractionResult.SUCCESS;
                    }
                    for (int y = 0; y <= worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) - pos.m_123342_(); ++y) {
                        BlockPos nPos = pos.m_142082_(0, y, 0);
                        BlockState nState = worldIn.m_8055_(nPos);
                        if (nState.m_60734_() instanceof PostBlock) {
                            EnumPostType type = (EnumPostType)((Object)nState.m_61143_(TYPE));
                            if (type != EnumPostType.POST && type != EnumPostType.POST_TOP && nState.m_61143_(FLIPSTATE) == EnumFlipState.DOWN) {
                                return InteractionResult.SUCCESS;
                            }
                            nState = worldIn.m_8055_(nPos.m_142300_(Direction.UP));
                            if (nState.m_60734_() instanceof PostBlock && (type = (EnumPostType)((Object)nState.m_61143_(TYPE))) != EnumPostType.POST && type != EnumPostType.POST_TOP) {
                                return InteractionResult.SUCCESS;
                            }
                        }
                        if (worldIn.m_46859_(nPos) || worldIn.m_8055_(nPos).m_60734_() == Blocks.f_49990_) {
                            BlockState fb = (BlockState)IPostMaterial.getPostState(held).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_8055_(nPos).m_60734_() == Blocks.f_49990_));
                            if (fb != null && !playerIn.m_142538_().equals((Object)nPos) && worldIn.m_46597_(nPos, fb) && !playerIn.m_7500_()) {
                                held.m_41774_(1);
                            }
                            return InteractionResult.SUCCESS;
                        }
                        if (worldIn.m_8055_(nPos).m_60734_() instanceof PostBlock) continue;
                        return InteractionResult.SUCCESS;
                    }
                    break block36;
                }
                if (!Utils.isHammer((ItemStack)held)) break block36;
                if (!playerIn.m_6144_()) break block38;
                switch ((EnumPostType)((Object)state.m_61143_(TYPE))) {
                    case POST: 
                    case POST_TOP: {
                        BlockState nState;
                        BlockPos nPos;
                        int size;
                        Direction facing = hit.m_82434_();
                        if (!Direction.Plane.HORIZONTAL.test(facing)) break;
                        BlockPos p = pos.m_142300_(facing);
                        BlockState hstate = worldIn.m_8055_(p);
                        if (hstate.m_60734_() instanceof HorizontalTrussBlock) {
                            this.replaceSelf(hstate, worldIn, p);
                            return InteractionResult.SUCCESS;
                        }
                        boolean success = false;
                        for (size = 0; size <= (Integer)IPOConfig.MAIN.maxTrussLength.get(); ++size) {
                            nPos = pos.m_5484_(facing, size + 1);
                            nState = worldIn.m_8055_(nPos);
                            if (nState.m_60795_()) continue;
                            if (nState.m_60734_() instanceof HorizontalTrussBlock) {
                                return InteractionResult.FAIL;
                            }
                            if (nState.m_60734_() instanceof PostBlock && ((EnumPostType)((Object)nState.m_61143_(TYPE))).id() <= 1) {
                                if (this.getPostMaterial() != ((PostBlock)nState.m_60734_()).getPostMaterial()) {
                                    playerIn.m_5661_((Component)new TranslatableComponent("immersiveposts.truss_notsametype"), true);
                                    return InteractionResult.FAIL;
                                }
                                success = true;
                                break;
                            }
                            if (nState.m_60734_() != Blocks.f_49990_) break;
                        }
                        if (success && size >= 1) {
                            if (size == 1) {
                                nPos = pos.m_142300_(facing);
                                nState = worldIn.m_8055_(nPos);
                                BlockState hState = (BlockState)((BlockState)IPostMaterial.getTrussState(this.getPostMaterial()).m_61124_((Property)HorizontalTrussBlock.FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(nState.m_60734_() == Blocks.f_49990_));
                                worldIn.m_46597_(nPos, hState.m_60728_(null, null, (LevelAccessor)worldIn, nPos, null));
                            } else {
                                for (int i = 0; i < size; ++i) {
                                    BlockPos nPos2 = pos.m_5484_(facing, i + 1);
                                    BlockState nState2 = worldIn.m_8055_(nPos2);
                                    BlockState hState = (BlockState)((BlockState)IPostMaterial.getTrussState(this.getPostMaterial()).m_61124_((Property)HorizontalTrussBlock.FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(nState2.m_60734_() == Blocks.f_49990_));
                                    hState = i == 0 ? (BlockState)hState.m_61124_(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_A)) : (i == size - 1 ? (i % 2 == 0 ? (BlockState)hState.m_61124_(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_D_ODD)) : (BlockState)hState.m_61124_(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_D_EVEN))) : (i % 2 == 0 ? (BlockState)hState.m_61124_(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_C)) : (BlockState)hState.m_61124_(HorizontalTrussBlock.TYPE, (Comparable)((Object)EnumHTrussType.MULTI_B))));
                                    worldIn.m_46597_(nPos2, hState.m_60728_(null, null, (LevelAccessor)worldIn, nPos2, null));
                                }
                            }
                            return InteractionResult.SUCCESS;
                        }
                        if (size == 0) {
                            playerIn.m_5661_((Component)new TranslatableComponent("immersiveposts.truss_minimumdistance"), true);
                            break;
                        }
                        if (!success && size >= 1) {
                            playerIn.m_5661_((Component)new TranslatableComponent("immersiveposts.truss_postnotfound"), true);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block36;
            }
            switch ((EnumPostType)((Object)state.m_61143_(TYPE))) {
                case POST: 
                case POST_TOP: {
                    Direction facing = hit.m_82434_();
                    BlockState defaultState = (BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)EnumPostType.ARM));
                    switch (facing) {
                        case NORTH: 
                        case EAST: 
                        case SOUTH: 
                        case WEST: {
                            BlockPos nPos = pos.m_142300_(facing);
                            BlockState nState = worldIn.m_8055_(nPos);
                            if (nState.m_60795_() || nState.m_60734_() == Blocks.f_49990_) {
                                defaultState = (BlockState)((BlockState)defaultState.m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(nState.m_60734_() == Blocks.f_49990_));
                                worldIn.m_46597_(nPos, defaultState);
                                defaultState.m_60690_(worldIn, nPos, (Block)this, null, false);
                                break;
                            }
                            if (PostBlock.getBlockFrom((BlockGetter)worldIn, nPos) != this) break;
                            switch ((EnumPostType)((Object)nState.m_61143_(TYPE))) {
                                case ARM: 
                                case EMPTY: {
                                    this.replaceSelf(nState, worldIn, nPos);
                                    return InteractionResult.SUCCESS;
                                }
                            }
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                case ARM: {
                    Direction bfacing = (Direction)state.m_61143_((Property)FACING);
                    BlockPos offset = pos.m_142300_(bfacing);
                    if (worldIn.m_46859_(offset) || worldIn.m_8055_(offset).m_60734_() == Blocks.f_49990_) {
                        worldIn.m_46597_(offset, (BlockState)((BlockState)state.m_61124_(TYPE, (Comparable)((Object)EnumPostType.ARM_DOUBLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_8055_(offset).m_60734_() == Blocks.f_49990_)));
                        worldIn.m_46597_(pos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)EnumPostType.EMPTY)));
                    }
                    return InteractionResult.SUCCESS;
                }
                case ARM_DOUBLE: {
                    Direction bfacing = (Direction)state.m_61143_((Property)FACING);
                    this.replaceSelf(state, worldIn, pos);
                    worldIn.m_46597_(pos.m_142300_(bfacing.m_122424_()), (BlockState)state.m_61124_(TYPE, (Comparable)((Object)EnumPostType.ARM)));
                    return InteractionResult.SUCCESS;
                }
                case EMPTY: {
                    Direction bfacing = (Direction)state.m_61143_((Property)FACING);
                    worldIn.m_46597_(pos, (BlockState)state.m_61124_(TYPE, (Comparable)((Object)EnumPostType.ARM)));
                    this.replaceSelf(state, worldIn, pos.m_142300_(bfacing));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (Utils.isHammer((ItemStack)playerIn.m_21205_()) || IPostMaterial.isValidItem(playerIn.m_21205_())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        this.updateState(state, world, pos);
    }

    private void updateState(BlockState stateIn, Level world, BlockPos pos) {
        BlockState state;
        EnumPostType thisType = (EnumPostType)((Object)stateIn.m_61143_(TYPE));
        if (thisType.id() <= 1 && ((state = world.m_8055_(pos.m_142300_(Direction.DOWN))).m_60734_() == Blocks.f_50016_ || state.m_60734_() == Blocks.f_49990_)) {
            Block.m_49950_((BlockState)stateIn, (Level)world, (BlockPos)pos);
            this.replaceSelf(stateIn, world, pos);
            return;
        }
        BlockState aboveState = world.m_8055_(pos.m_142300_(Direction.UP));
        Block aboveBlock = aboveState.m_60734_();
        switch (thisType) {
            case POST: {
                if (!(aboveBlock instanceof PostBlock)) {
                    world.m_46597_(pos, (BlockState)stateIn.m_61124_(TYPE, (Comparable)((Object)EnumPostType.POST_TOP)));
                }
                return;
            }
            case POST_TOP: {
                if (aboveBlock instanceof PostBlock && aboveState.m_61143_(TYPE) == EnumPostType.POST_TOP) {
                    world.m_46597_(pos, (BlockState)stateIn.m_61124_(TYPE, (Comparable)((Object)EnumPostType.POST)));
                }
                return;
            }
            case ARM: {
                Direction f = ((Direction)stateIn.m_61143_((Property)FACING)).m_122424_();
                BlockState state2 = world.m_8055_(pos.m_142300_(f));
                if (state2 != null && !(state2.m_60734_() instanceof PostBlock)) {
                    this.replaceSelf(stateIn, world, pos);
                } else {
                    world.m_46597_(pos, (BlockState)stateIn.m_61124_(FLIPSTATE, (Comparable)((Object)this.getFlipState((BlockGetter)world, pos))));
                }
                return;
            }
            case ARM_DOUBLE: {
                Direction f = ((Direction)stateIn.m_61143_((Property)FACING)).m_122424_();
                BlockState state3 = world.m_8055_(pos.m_142300_(f));
                if (state3 != null && !(state3.m_60734_() instanceof PostBlock)) {
                    this.replaceSelf(stateIn, world, pos);
                }
                return;
            }
            case EMPTY: {
                BlockState state4 = world.m_8055_(pos.m_142300_(((Direction)stateIn.m_61143_((Property)FACING)).m_122424_()));
                if (state4 != null && !(state4.m_60734_() instanceof PostBlock)) {
                    this.replaceSelf(stateIn, world, pos);
                    return;
                }
                state4 = world.m_8055_(pos.m_142300_((Direction)stateIn.m_61143_((Property)FACING)));
                if (state4.m_60734_() != Blocks.f_50016_ && state4.m_60734_() != Blocks.f_49990_) break;
                this.replaceSelf(stateIn, world, pos);
            }
        }
    }

    private EnumFlipState getFlipState(BlockGetter world, BlockPos pos) {
        boolean down;
        BlockState aboveState = world.m_8055_(pos.m_142300_(Direction.UP));
        BlockState belowState = world.m_8055_(pos.m_142300_(Direction.DOWN));
        Block aboveBlock = aboveState.m_60734_();
        Block belowBlock = belowState.m_60734_();
        boolean up = PostBlock.canConnect(world, pos, Direction.UP) && (!(aboveBlock instanceof PostBlock) || aboveState.m_61143_(TYPE) != EnumPostType.ARM);
        boolean bl = down = PostBlock.canConnect(world, pos, Direction.DOWN) && (!(belowBlock instanceof PostBlock) || belowState.m_61143_(TYPE) != EnumPostType.ARM);
        if (up && down) {
            return EnumFlipState.BOTH;
        }
        if (down) {
            return EnumFlipState.DOWN;
        }
        return EnumFlipState.UP;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return PostBlock.stateBounds(state);
    }

    private static VoxelShape stateBounds(BlockState state) {
        EnumPostType type = (EnumPostType)((Object)state.m_61143_(TYPE));
        switch (type) {
            case ARM: 
            case ARM_DOUBLE: {
                Direction dir = (Direction)state.m_61143_((Property)FACING);
                EnumFlipState flipstate = (EnumFlipState)((Object)state.m_61143_(FLIPSTATE));
                byte bid = 0;
                switch (flipstate) {
                    case UP: {
                        bid = 16;
                        break;
                    }
                    case DOWN: {
                        bid = 32;
                        break;
                    }
                    case BOTH: {
                        bid = 48;
                    }
                }
                switch (dir) {
                    case WEST: {
                        bid = (byte)(bid | 8);
                        break;
                    }
                    case SOUTH: {
                        bid = (byte)(bid | 4);
                        break;
                    }
                    case EAST: {
                        bid = (byte)(bid | 2);
                        break;
                    }
                    default: {
                        bid = (byte)(bid | 1);
                    }
                }
                if (!armMap.containsKey(bid)) {
                    double minY = 0.0;
                    double maxY = 1.0;
                    switch (flipstate) {
                        case UP: {
                            minY = 0.34375;
                            maxY = 1.0;
                            break;
                        }
                        case DOWN: {
                            minY = 0.0;
                            maxY = 0.65625;
                            break;
                        }
                        case BOTH: {
                            minY = 0.0;
                            maxY = 1.0;
                        }
                    }
                    double minX = dir == Direction.EAST ? 0.0 : 0.3125;
                    double maxX = dir == Direction.WEST ? 1.0 : 0.6875;
                    double minZ = dir == Direction.SOUTH ? 0.0 : 0.3125;
                    double maxZ = dir == Direction.NORTH ? 1.0 : 0.6875;
                    VoxelShape shape = Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                    armMap.put(bid, (Object)shape);
                    return shape;
                }
                return (VoxelShape)armMap.get(bid);
            }
            case EMPTY: {
                if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X) {
                    return X_BOUNDS;
                }
                return Z_BOUNDS;
            }
        }
        byte bid = 0;
        if (((Boolean)state.m_61143_((Property)LPARM_NORTH)).booleanValue()) {
            bid = (byte)(bid | 1);
        }
        if (((Boolean)state.m_61143_((Property)LPARM_SOUTH)).booleanValue()) {
            bid = (byte)(bid | 2);
        }
        if (((Boolean)state.m_61143_((Property)LPARM_EAST)).booleanValue()) {
            bid = (byte)(bid | 4);
        }
        if (((Boolean)state.m_61143_((Property)LPARM_WEST)).booleanValue()) {
            bid = (byte)(bid | 8);
        }
        if (!defaultMap.containsKey(bid)) {
            VoxelShape shape = POST_SHAPE;
            if (((Boolean)state.m_61143_((Property)LPARM_NORTH)).booleanValue()) {
                shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)LPARM_NORTH_BOUNDS, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)LPARM_SOUTH)).booleanValue()) {
                shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)LPARM_SOUTH_BOUNDS, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)LPARM_EAST)).booleanValue()) {
                shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)LPARM_EAST_BOUNDS, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)LPARM_WEST)).booleanValue()) {
                shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)LPARM_WEST_BOUNDS, (BooleanOp)BooleanOp.f_82695_);
            }
            shape = shape.m_83296_();
            defaultMap.put(bid, (Object)shape);
            return shape;
        }
        return (VoxelShape)defaultMap.get(bid);
    }

    public static boolean canConnect(BlockGetter worldIn, BlockPos posIn, Direction facingIn) {
        BlockPos nPos = posIn.m_142300_(facingIn);
        BlockState otherState = worldIn.m_8055_(nPos);
        Block otherBlock = otherState.m_60734_();
        if (otherBlock == Blocks.f_50016_ || otherState.m_60795_()) {
            return false;
        }
        if (otherBlock instanceof CrossCollisionBlock || otherBlock instanceof PostBlock || otherBlock instanceof HorizontalTrussBlock) {
            return false;
        }
        if (IPOTags.IGNORED_BY_POSTARM.m_8110_((Object)otherBlock)) {
            return false;
        }
        VoxelShape shape = otherState.m_60808_(worldIn, nPos);
        if (!shape.m_83281_()) {
            boolean b;
            AABB box = shape.m_83215_();
            switch (facingIn) {
                case UP: {
                    return Mth.m_14082_((double)0.0, (double)box.f_82289_);
                }
                case DOWN: {
                    boolean bool = otherBlock instanceof PostBlock;
                    return !bool && Mth.m_14082_((double)1.0, (double)box.f_82292_);
                }
                case NORTH: {
                    b = Mth.m_14082_((double)1.0, (double)box.f_82293_);
                    break;
                }
                case SOUTH: {
                    b = Mth.m_14082_((double)0.0, (double)box.f_82290_);
                    break;
                }
                case WEST: {
                    b = Mth.m_14082_((double)1.0, (double)box.f_82291_);
                    break;
                }
                case EAST: {
                    b = Mth.m_14082_((double)0.0, (double)box.f_82288_);
                    break;
                }
                default: {
                    b = false;
                }
            }
            if (b) {
                if (facingIn == Direction.SOUTH || facingIn == Direction.NORTH) {
                    AABB arm = LPARM_SOUTH_BOUNDS.m_83215_();
                    if ((box.f_82288_ > 0.0 && box.f_82291_ < 1.0 || box.f_82289_ > 0.0 && box.f_82292_ < 1.0) && box.f_82288_ <= arm.f_82288_ && box.f_82291_ >= arm.f_82291_ && box.f_82289_ <= arm.f_82289_ && box.f_82292_ >= arm.f_82292_) {
                        return true;
                    }
                } else if (facingIn == Direction.EAST || facingIn == Direction.WEST) {
                    AABB arm = LPARM_EAST_BOUNDS.m_83215_();
                    if ((box.f_82290_ > 0.0 && box.f_82293_ < 1.0 || box.f_82289_ > 0.0 && box.f_82292_ < 1.0) && box.f_82290_ <= arm.f_82290_ && box.f_82293_ >= arm.f_82293_ && box.f_82289_ <= arm.f_82289_ && box.f_82292_ >= arm.f_82292_) {
                        return true;
                    }
                }
                if (facingIn.m_122434_() == Direction.Axis.Z && box.f_82288_ > 0.0 && box.f_82291_ < 1.0) {
                    return true;
                }
                if (facingIn.m_122434_() == Direction.Axis.X && box.f_82290_ > 0.0 && box.f_82293_ < 1.0) {
                    return true;
                }
            }
        }
        return false;
    }
}

