/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.world.biomes;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.mrscauthd.beyond_earth.ModInit;

@Mod.EventBusSubscriber(modid="beyond_earth", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeRegistry {
    public static Biome moon;
    public static Biome mars;
    public static Biome mars_ice_spikes;
    public static Biome venus;
    public static Biome infernal_venus_barrens;
    public static Biome mercury;
    public static Biome glacio;
    public static Biome glacio_ice_spikes;
    public static Biome orbit;

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        MobSpawnSettings mobSpawnInfo;
        BiomeGenerationSettings.Builder biomeGenerationSettings;
        BiomeSpecialEffects effects;
        if (moon == null) {
            effects = new BiomeSpecialEffects.Builder().m_48019_(-16777216).m_48034_(4159204).m_48037_(329011).m_48040_(-16777216).m_48043_(7842607).m_48045_(9551193).m_48018_();
            biomeGenerationSettings = new BiomeGenerationSettings.Builder();
            BiomeDefaultFeatures.m_176863_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
            BiomeRegistry.addDefaultCarvers(biomeGenerationSettings);
            mobSpawnInfo = new MobSpawnSettings.Builder().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModInit.ALIEN_ZOMBIE.get(), 20, 5, 5)).m_48370_((EntityType)ModInit.ALIEN_ZOMBIE.get(), 0.7, 0.15).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModInit.STAR_CRAWLER.get(), 20, 5, 5)).m_48370_((EntityType)ModInit.STAR_CRAWLER.get(), 0.7, 0.15).m_48381_();
            moon = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47605_(mobSpawnInfo).m_47609_(-0.7f).m_47611_(0.0f).m_47603_(effects).m_47601_(biomeGenerationSettings.m_47831_()).m_47592_();
            event.getRegistry().register((IForgeRegistryEntry)((Biome)moon.setRegistryName("beyond_earth", "moon")));
        }
        if (mars == null) {
            effects = new BiomeSpecialEffects.Builder().m_48019_(-3044526).m_48034_(4159204).m_48037_(329011).m_48040_(-3044526).m_48043_(7842607).m_48045_(9551193).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123784_, 0.014f)).m_48018_();
            biomeGenerationSettings = new BiomeGenerationSettings.Builder();
            BiomeRegistry.addDefaultCarvers(biomeGenerationSettings);
            BiomeRegistry.addLushCavesVegetationFeatures(biomeGenerationSettings);
            BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
            mobSpawnInfo = new MobSpawnSettings.Builder().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModInit.MARTIAN_RAPTOR.get(), 20, 5, 5)).m_48370_((EntityType)ModInit.MARTIAN_RAPTOR.get(), 0.7, 0.15).m_48381_();
            mars = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47605_(mobSpawnInfo).m_47609_(-0.7f).m_47611_(0.0f).m_47603_(effects).m_47601_(biomeGenerationSettings.m_47831_()).m_47592_();
            event.getRegistry().register((IForgeRegistryEntry)((Biome)mars.setRegistryName("beyond_earth", "mars")));
        }
        if (mars_ice_spikes == null) {
            effects = new BiomeSpecialEffects.Builder().m_48019_(-3044526).m_48034_(4159204).m_48037_(329011).m_48040_(-3044526).m_48043_(7842607).m_48045_(9551193).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123784_, 0.014f)).m_48018_();
            biomeGenerationSettings = new BiomeGenerationSettings.Builder();
            BiomeRegistry.addDefaultCarvers(biomeGenerationSettings);
            BiomeRegistry.addLushCavesVegetationFeatures(biomeGenerationSettings);
            BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
            mobSpawnInfo = MobSpawnSettings.f_48326_;
            mars_ice_spikes = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.ICY).m_47605_(mobSpawnInfo).m_47609_(-0.7f).m_47611_(0.0f).m_47603_(effects).m_47601_(biomeGenerationSettings.m_47831_()).m_47592_();
            event.getRegistry().register((IForgeRegistryEntry)((Biome)mars_ice_spikes.setRegistryName("beyond_earth", "mars_ice_spikes")));
        }
        if (venus == null) {
            effects = new BiomeSpecialEffects.Builder().m_48019_(-3044526).m_48034_(4159204).m_48037_(329011).m_48040_(-3044526).m_48043_(7842607).m_48045_(9551193).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123784_, 0.02f)).m_48018_();
            biomeGenerationSettings = new BiomeGenerationSettings.Builder();
            BiomeRegistry.addDefaultCarvers(biomeGenerationSettings);
            mobSpawnInfo = MobSpawnSettings.f_48326_;
            venus = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.NONE).m_47605_(mobSpawnInfo).m_47609_(1.5f).m_47611_(1.0f).m_47603_(effects).m_47601_(biomeGenerationSettings.m_47831_()).m_47592_();
            event.getRegistry().register((IForgeRegistryEntry)((Biome)venus.setRegistryName("beyond_earth", "venus")));
        }
        if (infernal_venus_barrens == null) {
            effects = new BiomeSpecialEffects.Builder().m_48019_(-3044526).m_48034_(4159204).m_48037_(329011).m_48040_(-3044526).m_48043_(7842607).m_48045_(9551193).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123784_, 0.02f)).m_48018_();
            biomeGenerationSettings = new BiomeGenerationSettings.Builder();
            BiomeRegistry.addDefaultCarvers(biomeGenerationSettings);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.SURFACE_STRUCTURES, NetherPlacements.f_195279_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195282_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195283_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195293_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195299_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195298_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, OrePlacements.f_195315_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195295_);
            mobSpawnInfo = MobSpawnSettings.f_48326_;
            infernal_venus_barrens = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47595_(Biome.BiomeCategory.NONE).m_47605_(mobSpawnInfo).m_47609_(1.5f).m_47611_(1.0f).m_47603_(effects).m_47601_(biomeGenerationSettings.m_47831_()).m_47592_();
            event.getRegistry().register((IForgeRegistryEntry)((Biome)infernal_venus_barrens.setRegistryName("beyond_earth", "infernal_venus_barrens")));
        }
        if (mercury == null) {
            effects = new BiomeSpecialEffects.Builder().m_48019_(-16777216).m_48034_(4159204).m_48037_(329011).m_48040_(-16777216).m_48043_(7842607).m_48045_(9551193).m_48018_();
            biomeGenerationSettings = new BiomeGenerationSettings.Builder();
            BiomeRegistry.addDefaultCarvers(biomeGenerationSettings);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.SURFACE_STRUCTURES, NetherPlacements.f_195279_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195292_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195282_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195283_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195293_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195299_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195298_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, OrePlacements.f_195315_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195295_);
            mobSpawnInfo = MobSpawnSettings.f_48326_;
            mercury = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47605_(mobSpawnInfo).m_47609_(1.6f).m_47611_(0.0f).m_47603_(effects).m_47601_(biomeGenerationSettings.m_47831_()).m_47592_();
            event.getRegistry().register((IForgeRegistryEntry)((Biome)mercury.setRegistryName("beyond_earth", "mercury")));
        }
        if (glacio == null) {
            effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(BiomeRegistry.calculateSkyColor(-0.7f)).m_48043_(0xFFFFFF).m_48018_();
            biomeGenerationSettings = new BiomeGenerationSettings.Builder();
            BiomeRegistry.addDefaultCarvers(biomeGenerationSettings);
            BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
            BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
            mobSpawnInfo = MobSpawnSettings.f_48326_;
            glacio = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.NONE).m_47605_(mobSpawnInfo).m_47609_(-0.7f).m_47611_(1.0f).m_47603_(effects).m_47601_(biomeGenerationSettings.m_47831_()).m_47592_();
            event.getRegistry().register((IForgeRegistryEntry)((Biome)glacio.setRegistryName("beyond_earth", "glacio")));
        }
        if (glacio_ice_spikes == null) {
            effects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48040_(BiomeRegistry.calculateSkyColor(-0.7f)).m_48043_(0xFFFFFF).m_48018_();
            biomeGenerationSettings = new BiomeGenerationSettings.Builder();
            BiomeRegistry.addDefaultCarvers(biomeGenerationSettings);
            BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
            BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeGenerationSettings);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.f_195260_);
            biomeGenerationSettings.m_186664_(GenerationStep.Decoration.SURFACE_STRUCTURES, MiscOverworldPlacements.f_195261_);
            mobSpawnInfo = MobSpawnSettings.f_48326_;
            glacio_ice_spikes = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47595_(Biome.BiomeCategory.NONE).m_47605_(mobSpawnInfo).m_47609_(-0.7f).m_47611_(1.0f).m_47603_(effects).m_47601_(biomeGenerationSettings.m_47831_()).m_47592_();
            event.getRegistry().register((IForgeRegistryEntry)((Biome)glacio_ice_spikes.setRegistryName("beyond_earth", "glacio_ice_spikes")));
        }
        if (orbit == null) {
            effects = new BiomeSpecialEffects.Builder().m_48019_(-16777216).m_48034_(4159204).m_48037_(329011).m_48040_(-16777216).m_48043_(7842607).m_48045_(9551193).m_48018_();
            biomeGenerationSettings = new BiomeGenerationSettings.Builder();
            mobSpawnInfo = MobSpawnSettings.f_48326_;
            orbit = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47605_(mobSpawnInfo).m_47609_(1.6f).m_47611_(0.0f).m_47603_(effects).m_47601_(biomeGenerationSettings.m_47831_()).m_47592_();
            event.getRegistry().register((IForgeRegistryEntry)((Biome)orbit.setRegistryName("beyond_earth", "orbit")));
        }
    }

    public static void addDefaultCarvers(BiomeGenerationSettings.Builder p_194721_) {
        p_194721_.m_47839_(GenerationStep.Carving.AIR, Carvers.f_126848_);
        p_194721_.m_47839_(GenerationStep.Carving.AIR, Carvers.f_194741_);
        p_194721_.m_47839_(GenerationStep.Carving.AIR, Carvers.f_126849_);
    }

    protected static int calculateSkyColor(float p_194844_) {
        float $$1 = p_194844_ / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    public static void addLushCavesVegetationFeatures(BiomeGenerationSettings.Builder p_176851_) {
        p_176851_.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195248_);
        p_176851_.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195245_);
        p_176851_.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195247_);
        p_176851_.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195246_);
        p_176851_.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195249_);
        p_176851_.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195250_);
    }
}

