/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.skyrenderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ICloudRenderHandler;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="beyond_earth", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventBusGlacioOrbit {
    private static final ResourceLocation DIM_RENDER_INFO = new ResourceLocation("beyond_earth", "glacio_orbit");
    @Nullable
    public static VertexBuffer starBuffer;
    private static final ResourceLocation GLACIO_TEXTURE;
    private static final ResourceLocation SUN_TEXTURE;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void clientSetup(FMLClientSetupEvent event) {
        DimensionSpecialEffects.f_108857_.put((Object)DIM_RENDER_INFO, (Object)new DimensionSpecialEffects(192.0f, false, DimensionSpecialEffects.SkyType.NORMAL, false, false){

            public Vec3 m_5927_(Vec3 p_108878_, float p_108879_) {
                return p_108878_;
            }

            public boolean m_5781_(int p_108874_, int p_108875_) {
                return false;
            }

            public ICloudRenderHandler getCloudRenderHandler() {
                return new ICloudRenderHandler(){

                    public void render(int ticks, float partialTicks, PoseStack matrixStack, ClientLevel world, Minecraft mc, double viewEntityX, double viewEntityY, double viewEntityZ) {
                    }
                };
            }

            public ISkyRenderHandler getSkyRenderHandler() {
                return new ISkyRenderHandler(){

                    public void render(int ticks, float p_181412_, PoseStack p_181410_, ClientLevel level, Minecraft minecraft) {
                        Matrix4f matrix4f = RenderSystem.m_157192_();
                        Matrix4f starmatrix4f = RenderSystem.m_157192_();
                        RenderSystem.m_69472_();
                        Vec3 vec3 = level.m_171660_(minecraft.f_91063_.m_109153_().m_90583_(), p_181412_);
                        float f = (float)vec3.f_82479_;
                        float f1 = (float)vec3.f_82480_;
                        float f2 = (float)vec3.f_82481_;
                        FogRenderer.m_109036_();
                        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                        RenderSystem.m_69458_((boolean)false);
                        RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
                        ShaderInstance shaderinstance = RenderSystem.m_157196_();
                        minecraft.f_91060_.f_109472_.m_166867_(p_181410_.m_85850_().m_85861_(), matrix4f, shaderinstance);
                        RenderSystem.m_69478_();
                        RenderSystem.m_69453_();
                        float[] afloat = level.m_104583_().m_7518_(level.m_46942_(p_181412_), p_181412_);
                        if (afloat != null) {
                            RenderSystem.m_157427_(GameRenderer::m_172811_);
                            RenderSystem.m_69472_();
                            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            p_181410_.m_85836_();
                            p_181410_.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                            float f3 = Mth.m_14031_((float)level.m_46490_(p_181412_)) < 0.0f ? 180.0f : 0.0f;
                            p_181410_.m_85845_(Vector3f.f_122227_.m_122240_(f3));
                            p_181410_.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                            float f4 = afloat[0];
                            float f5 = afloat[1];
                            float f6 = afloat[2];
                            matrix4f = p_181410_.m_85850_().m_85861_();
                            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                            bufferbuilder.m_85982_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
                            for (int j = 0; j <= 16; ++j) {
                                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                                float f8 = Mth.m_14031_((float)f7);
                                float f9 = Mth.m_14089_((float)f7);
                                bufferbuilder.m_85982_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
                            }
                            bufferbuilder.m_85721_();
                            BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
                            p_181410_.m_85849_();
                        }
                        RenderSystem.m_69493_();
                        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        p_181410_.m_85836_();
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        p_181410_.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                        p_181410_.m_85845_(Vector3f.f_122223_.m_122240_(0.0f));
                        Matrix4f matrix4f1 = p_181410_.m_85850_().m_85861_();
                        RenderSystem.m_157427_(GameRenderer::m_172817_);
                        RenderSystem.m_69458_((boolean)true);
                        RenderSystem.m_69482_();
                        float var20 = -3000.0f + (float)Minecraft.m_91087_().f_91074_.m_20186_() * 6.0f;
                        float scale = 100.0f * (0.3f - var20 / 10000.0f);
                        scale = Math.max(scale, 4.0f);
                        RenderSystem.m_157456_((int)0, (ResourceLocation)GLACIO_TEXTURE);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                        bufferbuilder.m_85982_(matrix4f1, -scale, -180.0f, scale).m_7421_(0.0f, 0.0f).m_5752_();
                        bufferbuilder.m_85982_(matrix4f1, scale, -180.0f, scale).m_7421_(1.0f, 0.0f).m_5752_();
                        bufferbuilder.m_85982_(matrix4f1, scale, -180.0f, -scale).m_7421_(1.0f, 1.0f).m_5752_();
                        bufferbuilder.m_85982_(matrix4f1, -scale, -180.0f, -scale).m_7421_(0.0f, 1.0f).m_5752_();
                        bufferbuilder.m_85721_();
                        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
                        RenderSystem.m_69458_((boolean)false);
                        p_181410_.m_85845_(Vector3f.f_122223_.m_122240_(level.m_46942_(p_181412_) * 360.0f));
                        matrix4f1 = p_181410_.m_85850_().m_85861_();
                        float f12 = 70.0f;
                        RenderSystem.m_157456_((int)0, (ResourceLocation)SUN_TEXTURE);
                        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                        bufferbuilder.m_85982_(matrix4f1, -f12, 200.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
                        bufferbuilder.m_85982_(matrix4f1, f12, 200.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
                        bufferbuilder.m_85982_(matrix4f1, f12, 200.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
                        bufferbuilder.m_85982_(matrix4f1, -f12, 200.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
                        bufferbuilder.m_85721_();
                        BufferUploader.m_85761_((BufferBuilder)bufferbuilder);
                        RenderSystem.m_69472_();
                        this.createStars();
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        FogRenderer.m_109017_();
                        starBuffer.m_166867_(p_181410_.m_85850_().m_85861_(), starmatrix4f, GameRenderer.m_172808_());
                        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderSystem.m_69461_();
                        p_181410_.m_85849_();
                        RenderSystem.m_69472_();
                        RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        if (level.m_104583_().m_108882_()) {
                            RenderSystem.m_157429_((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f), (float)1.0f);
                        } else {
                            RenderSystem.m_157429_((float)f, (float)f1, (float)f2, (float)1.0f);
                        }
                        RenderSystem.m_69493_();
                        RenderSystem.m_69458_((boolean)true);
                        RenderSystem.m_69465_();
                    }
                };
            }

            private void createStars() {
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                RenderSystem.m_157427_(GameRenderer::m_172808_);
                if (starBuffer != null) {
                    starBuffer.close();
                }
                starBuffer = new VertexBuffer();
                this.drawStars(bufferbuilder);
                bufferbuilder.m_85721_();
                starBuffer.m_85925_(bufferbuilder);
            }

            private void drawStars(BufferBuilder p_109555_) {
                Random random = new Random(10842L);
                p_109555_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                int stars = 0;
                stars = Minecraft.m_91087_().f_91066_.f_92115_ == GraphicsStatus.FANCY || Minecraft.m_91087_().f_91066_.f_92115_ == GraphicsStatus.FABULOUS ? 13000 : 6000;
                for (int i = 0; i < stars; ++i) {
                    double d0 = random.nextFloat() * 2.0f - 1.0f;
                    double d1 = random.nextFloat() * 2.0f - 1.0f;
                    double d2 = random.nextFloat() * 2.0f - 1.0f;
                    double d3 = 0.15f + random.nextFloat() * 0.1f;
                    double d4 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
                    d4 = 1.0 / Math.sqrt(d4);
                    double d5 = (d0 *= d4) * 200.0;
                    double d6 = (d1 *= d4) * 200.0;
                    double d7 = (d2 *= d4) * 200.0;
                    double d8 = Math.atan2(d0, d2);
                    double d9 = Math.sin(d8);
                    double d10 = Math.cos(d8);
                    double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
                    double d12 = Math.sin(d11);
                    double d13 = Math.cos(d11);
                    double d14 = random.nextDouble() * Math.PI * 2.0;
                    double d15 = Math.sin(d14);
                    double d16 = Math.cos(d14);
                    for (int j = 0; j < 4; ++j) {
                        double d17 = 0.0;
                        double d18 = (double)((j & 2) - 1) * d3;
                        double d19 = (double)((j + 1 & 2) - 1) * d3;
                        double d20 = 0.0;
                        double d21 = d18 * d16 - d19 * d15;
                        double d22 = d19 * d16 + d18 * d15;
                        double d23 = d21 * d12 + 0.0 * d13;
                        double d24 = 0.0 * d12 - d21 * d13;
                        double d25 = d24 * d9 - d22 * d10;
                        double d26 = d22 * d9 + d24 * d10;
                        p_109555_.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
                    }
                }
            }
        });
    }

    static {
        GLACIO_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/glacio.png");
        SUN_TEXTURE = new ResourceLocation("beyond_earth", "textures/sky/no_a_sun.png");
    }
}

