/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class StackCacher {
    private final List<Object> list = new ArrayList<Object>();

    public boolean test(ItemStack stack) {
        return this.test(Lists.newArrayList((Object[])new ItemStack[]{stack}));
    }

    public boolean test(FluidStack stack) {
        return this.test(Lists.newArrayList((Object[])new FluidStack[]{stack}));
    }

    public boolean test(Collection<? extends Object> stacks) {
        List<Object> list = this.getStacks();
        ArrayList<? extends Object> tests = new ArrayList<Object>(stacks);
        int size = list.size();
        if (size != tests.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Object right;
            Object left = list.get(i);
            if (this.test(left, right = tests.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean test(Object left, Object right) {
        if (left instanceof ItemStack) {
            if (right instanceof ItemStack) {
                return this.test((ItemStack)left, (ItemStack)right);
            }
        } else if (right instanceof FluidStack) {
            return this.test((FluidStack)left, (FluidStack)right);
        }
        return false;
    }

    public boolean test(ItemStack left, ItemStack right) {
        if (left.m_41619_() && right.m_41619_()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)left, (ItemStack)right);
    }

    public boolean test(FluidStack left, FluidStack right) {
        if (left.isEmpty() && right.isEmpty()) {
            return true;
        }
        return left.getFluid().m_6212_(right.getFluid()) && FluidStack.areFluidStackTagsEqual((FluidStack)left, (FluidStack)right);
    }

    public void set(ItemStack stack) {
        this.set(Lists.newArrayList((Object[])new ItemStack[]{stack}));
    }

    public void set(FluidStack stack) {
        this.set(Lists.newArrayList((Object[])new FluidStack[]{stack}));
    }

    public void set(Collection<? extends Object> stacks) {
        this.list.clear();
        for (Object object : stacks) {
            if (object instanceof ItemStack) {
                this.list.add(((ItemStack)object).m_41777_());
                continue;
            }
            if (!(object instanceof FluidStack)) continue;
            this.list.add(((FluidStack)object).copy());
        }
    }

    public List<Object> getStacks() {
        return Collections.unmodifiableList(this.list);
    }
}

