/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.gui.screens.rocket;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.network.IContainerFactory;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.entity.RocketTier1Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier2Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier3Entity;
import net.mrscauthd.beyond_earth.entity.RocketTier4Entity;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.fluid.FluidUtil2;
import net.mrscauthd.beyond_earth.gui.helper.ContainerHelper;
import org.jetbrains.annotations.NotNull;

public class RocketGui {

    public static class GuiContainer
    extends AbstractContainerMenu {
        Entity rocket;

        public GuiContainer(int id, Inventory inv, FriendlyByteBuf extraData) {
            super((MenuType)ModInit.ROCKET_GUI.get(), id);
            this.rocket = inv.f_35978_.f_19853_.m_6815_(extraData.m_130242_());
            IItemHandlerModifiable itemHandler = null;
            if (this.rocket instanceof RocketTier1Entity) {
                itemHandler = ((RocketTier1Entity)this.rocket).getItemHandler();
            } else if (this.rocket instanceof RocketTier2Entity) {
                itemHandler = ((RocketTier2Entity)this.rocket).getItemHandler();
            } else if (this.rocket instanceof RocketTier3Entity) {
                itemHandler = ((RocketTier3Entity)this.rocket).getItemHandler();
            } else if (this.rocket instanceof RocketTier4Entity) {
                itemHandler = ((RocketTier4Entity)this.rocket).getItemHandler();
            }
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 0, 46, 22){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return Methods.tagCheck(FluidUtil2.findBucketFluid(stack.m_41720_()), ModInit.FLUID_VEHICLE_FUEL_TAG);
                }
            });
            ContainerHelper.addInventorySlots(this, inv, 8, 84, x$0 -> this.m_38897_((Slot)x$0));
        }

        public boolean m_6875_(Player p_38874_) {
            return !this.rocket.m_146910_();
        }

        public ItemStack m_7648_(Player playerIn, int index) {
            return ContainerHelper.transferStackInSlot((AbstractContainerMenu)this, playerIn, index, 0, 1, (x$0, x$1, x$2, x$3) -> this.m_38903_(x$0, x$1, x$2, x$3));
        }
    }

    public static class GuiContainerFactory
    implements IContainerFactory<GuiContainer> {
        public GuiContainer create(int id, Inventory inv, FriendlyByteBuf extraData) {
            return new GuiContainer(id, inv, extraData);
        }
    }
}

