/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.events;

import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.events.forgeevents.LivingGravityEvent;

public class Gravity {
    public static void Gravity(LivingEntity entity, GravityType type, Level world) {
        double moon = 0.03;
        double mars = 0.04;
        double mercury = 0.03;
        double venus = 0.04;
        double orbit = 0.02;
        if (Methods.isWorld(world, Methods.moon)) {
            Gravity.gravityMath(type, entity, moon, -2.5f);
        }
        if (Methods.isWorld(world, Methods.mars)) {
            Gravity.gravityMath(type, entity, mars, -2.0f);
        }
        if (Methods.isWorld(world, Methods.glacio)) {
            Gravity.gravityMath(type, entity, mars, -2.0f);
        }
        if (Methods.isWorld(world, Methods.mercury)) {
            Gravity.gravityMath(type, entity, mercury, -2.5f);
        }
        if (Methods.isWorld(world, Methods.venus)) {
            Gravity.gravityMath(type, entity, venus, -2.0f);
        }
        if (Methods.isOrbitWorld(world)) {
            Gravity.gravityMath(type, entity, orbit, -2.5f);
        }
    }

    public static boolean playerGravityCheck(Player player) {
        return !player.m_150110_().f_35935_ && !player.m_21255_() && !player.m_20069_() && !player.m_20077_() && !player.m_20068_() && !player.m_21023_(MobEffects.f_19591_) && !player.m_21023_(MobEffects.f_19620_);
    }

    public static boolean livingGravityCheck(LivingEntity entity) {
        return !entity.m_21255_() && !entity.m_20069_() && !entity.m_20077_() && !entity.m_20068_() && !(entity instanceof Player) && !Methods.AllVehiclesOr((Entity)entity) && !entity.m_21023_(MobEffects.f_19591_) && !entity.m_21023_(MobEffects.f_19620_);
    }

    public static void gravityMath(GravityType type, LivingEntity entity, double gravity, float fallDistance) {
        if (!Gravity.checkType(type, entity)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingGravityEvent(entity))) {
            return;
        }
        entity.m_20334_(entity.m_20184_().m_7096_(), entity.m_20184_().m_7098_() / 0.98 + 0.08 - gravity, entity.m_20184_().m_7094_());
        Gravity.fallDamage(entity, fallDistance);
    }

    public static boolean checkType(GravityType type, LivingEntity entity) {
        if (type == GravityType.PLAYER && Gravity.playerGravityCheck((Player)entity)) {
            return true;
        }
        return type == GravityType.LIVING && Gravity.livingGravityCheck(entity);
    }

    public static void fallDamage(LivingEntity entity, float fallDistance) {
        if (entity.m_20184_().m_7098_() < -0.1) {
            entity.f_19789_ = (float)entity.m_20184_().m_7098_() * fallDistance;
        }
    }

    public static enum GravityType {
        PLAYER,
        LIVING;

    }
}

