/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.events;

import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.beyond_earth.ModInit;
import net.mrscauthd.beyond_earth.entity.LanderEntity;
import net.mrscauthd.beyond_earth.events.Gravity;
import net.mrscauthd.beyond_earth.events.Methods;
import net.mrscauthd.beyond_earth.events.OxygenSystem;
import net.mrscauthd.beyond_earth.events.SpaceSoundSystem;
import net.mrscauthd.beyond_earth.events.TickableSpaceSoundSystem;
import net.mrscauthd.beyond_earth.events.forgeevents.RenderHandItemEvent;
import net.mrscauthd.beyond_earth.events.forgeevents.SetupLivingBipedAnimEvent;
import net.mrscauthd.beyond_earth.item.VehicleItem;

@Mod.EventBusSubscriber(modid="beyond_earth")
public class Events {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            Level world = player.f_19853_;
            if (player.m_20202_() instanceof LanderEntity) {
                Methods.landerTeleportOrbit(player, world);
            }
            Methods.openPlanetGui(player);
            OxygenSystem.OxygenSystem(player);
            Gravity.Gravity((LivingEntity)player, Gravity.GravityType.PLAYER, world);
            Methods.DropRocket(player);
            if (player.m_20186_() < 1.0 && !(player.m_20202_() instanceof LanderEntity)) {
                Methods.playerFalltoPlanet(world, player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level world = entity.f_19853_;
        Methods.EntityOxygen(entity, world);
        Gravity.Gravity(entity, Gravity.GravityType.LIVING, world);
        Methods.VenusRain(entity, Methods.venus);
        Methods.PlanetFire(entity, Methods.venus, Methods.mercury);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void CameraPos(EntityViewRenderEvent.CameraSetup event) {
        CameraType pointOfView;
        Entity ridding = event.getCamera().m_90592_().m_20202_();
        if ((Methods.isRocket(ridding) || ridding instanceof LanderEntity) && ((pointOfView = Minecraft.m_91087_().f_91066_.m_92176_()).equals((Object)CameraType.THIRD_PERSON_FRONT) || pointOfView.equals((Object)CameraType.THIRD_PERSON_BACK))) {
            event.getCamera().m_90568_(-event.getCamera().m_90566_(12.0), 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderPlayerArm(RenderArmEvent event) {
        PlayerModel playerModel = (PlayerModel)((PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)event.getPlayer())).m_7200_();
        AbstractClientPlayer player = event.getPlayer();
        Item item = player.m_21206_().m_41720_();
        Item item2 = player.m_21205_().m_41720_();
        if (item instanceof VehicleItem || item2 instanceof VehicleItem) {
            event.setCanceled(true);
            return;
        }
        if (event.getArm() == HumanoidArm.RIGHT) {
            if (Methods.checkArmor((LivingEntity)event.getPlayer(), 2, (Item)ModInit.SPACE_SUIT.get())) {
                Methods.renderArm(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), new ResourceLocation("beyond_earth", "textures/models/armor/arm/space_suit.png"), event.getPlayer(), (PlayerModel<AbstractClientPlayer>)playerModel, playerModel.f_102811_);
                event.setCanceled(true);
            } else if (Methods.checkArmor((LivingEntity)event.getPlayer(), 2, (Item)ModInit.NETHERITE_SPACE_SUIT.get())) {
                Methods.renderArm(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), new ResourceLocation("beyond_earth", "textures/models/armor/arm/netherite_space_suit.png"), event.getPlayer(), (PlayerModel<AbstractClientPlayer>)playerModel, playerModel.f_102811_);
                event.setCanceled(true);
            }
        }
        if (event.getArm() == HumanoidArm.LEFT) {
            if (Methods.checkArmor((LivingEntity)event.getPlayer(), 2, (Item)ModInit.SPACE_SUIT.get())) {
                Methods.renderArm(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), new ResourceLocation("beyond_earth", "textures/models/armor/arm/space_suit.png"), event.getPlayer(), (PlayerModel<AbstractClientPlayer>)playerModel, playerModel.f_102812_);
                event.setCanceled(true);
            } else if (Methods.checkArmor((LivingEntity)event.getPlayer(), 2, (Item)ModInit.NETHERITE_SPACE_SUIT.get())) {
                Methods.renderArm(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), new ResourceLocation("beyond_earth", "textures/models/armor/arm/netherite_space_suit.png"), event.getPlayer(), (PlayerModel<AbstractClientPlayer>)playerModel, playerModel.f_102812_);
                event.setCanceled(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void render(RenderPlayerEvent event) {
        if (event.getEntity().m_20202_() instanceof LanderEntity) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void setupPlayerAngles(SetupLivingBipedAnimEvent.Post event) {
        if (event.getLivingEntity() instanceof Player) {
            Player player = (Player)event.getLivingEntity();
            HumanoidModel model = event.getModel();
            if (Methods.isRocket(player.m_20202_())) {
                model.f_102813_.f_104203_ = (float)Math.toRadians(0.0);
                model.f_102814_.f_104203_ = (float)Math.toRadians(0.0);
                model.f_102814_.f_104204_ = (float)Math.toRadians(3.0);
                model.f_102814_.f_104204_ = (float)Math.toRadians(3.0);
                model.f_102812_.f_104203_ = -0.07f;
                model.f_102811_.f_104203_ = -0.07f;
            }
            if (!Methods.isRocket(player.m_20202_())) {
                Item item1 = player.m_21205_().m_41720_();
                Item item2 = player.m_21206_().m_41720_();
                if (item1 instanceof VehicleItem || item2 instanceof VehicleItem) {
                    model.f_102811_.f_104203_ = 10.0f;
                    model.f_102812_.f_104203_ = 10.0f;
                    model.f_102811_.f_104205_ = 0.0f;
                    model.f_102812_.f_104205_ = 0.0f;
                    model.f_102811_.f_104204_ = 0.0f;
                    model.f_102812_.f_104204_ = 0.0f;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void ItemRender(RenderHandItemEvent.Pre event) {
        if (event.getLivingEntity() instanceof Player) {
            Player player = (Player)event.getLivingEntity();
            if (Methods.isRocket(player.m_20202_())) {
                event.setCanceled(true);
            }
            Item item1 = player.m_21205_().m_41720_();
            Item item2 = player.m_21206_().m_41720_();
            if (item1 instanceof VehicleItem && event.getHandSide() == HumanoidArm.LEFT) {
                event.setCanceled(true);
            }
            if (item2 instanceof VehicleItem && event.getHandSide() == HumanoidArm.RIGHT) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Level world = event.world;
            if (Methods.isWorld(world, Methods.moon) || Methods.isWorld(world, Methods.moon_orbit) || Methods.isWorld(world, Methods.mars) || Methods.isWorld(world, Methods.mars_orbit) || Methods.isWorld(world, Methods.mercury) || Methods.isWorld(world, Methods.mercury_orbit) || Methods.isWorld(world, Methods.venus_orbit) || Methods.isWorld(world, Methods.glacio_orbit) || Methods.isWorld(world, Methods.overworld_orbit)) {
                world.f_46440_ = 0.0f;
                world.f_46438_ = 0.0f;
            }
            if (Methods.isWorld(world, Methods.venus)) {
                world.f_46440_ = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        Player entity;
        if (event != null && event.getEntity() instanceof Player && Methods.netheriteSpaceSuitCheck((LivingEntity)(entity = (Player)event.getEntity())) && event.getSource().m_19384_()) {
            entity.m_7311_(0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void FishingBobberTick(ProjectileImpactEvent event) {
        Entity entity;
        if (event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && Methods.AllVehiclesOr(entity = ((EntityHitResult)event.getRayTraceResult()).m_82443_())) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void SpaceSounds(PlaySoundEvent event) {
        if (event.getSound() != null && Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.f_19853_ != null && Methods.checkSound(event.getSound().m_8070_()) && Methods.isSpaceWorldWithoutOxygen(Minecraft.m_91087_().f_91074_.f_19853_)) {
            if (!(event.getSound() instanceof TickableSoundInstance)) {
                event.setSound((SoundInstance)new SpaceSoundSystem(event.getSound()));
            } else if (event.getSound() instanceof TickableSoundInstance) {
                event.setSound((SoundInstance)new TickableSpaceSoundSystem((TickableSoundInstance)event.getSound()));
            }
        }
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        if (event.getEntity() instanceof Player && event.getEntity().getPersistentData().m_128471_("beyond_earth:planet_selection_gui_open")) {
            ((Player)event.getEntity()).m_6915_();
            Methods.cleanUpPlayerNBT((Player)event.getEntity());
            event.getEntity().m_20242_(false);
        }
    }
}

