/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.entity.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.beyond_earth.entity.RoverEntity;
import net.mrscauthd.beyond_earth.entity.VehicleEntity;

@OnlyIn(value=Dist.CLIENT)
public abstract class VehicleRenderer<T extends VehicleEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    protected M model;
    protected final List<RenderLayer<T, M>> layers = Lists.newArrayList();

    public VehicleRenderer(EntityRendererProvider.Context p_174289_, M p_174290_, float p_174291_) {
        super(p_174289_);
        this.model = p_174290_;
        this.f_114477_ = p_174291_;
    }

    public final boolean addLayer(RenderLayer<T, M> p_115327_) {
        return this.layers.add(p_115327_);
    }

    public M m_7200_() {
        return this.model;
    }

    public void render(T p_115308_, float p_115309_, float p_115310_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        boolean shouldSit;
        p_115311_.m_85836_();
        ((EntityModel)this.model).f_102609_ = shouldSit = p_115308_.m_20159_() && p_115308_.m_20202_() != null && p_115308_.m_20202_().shouldRiderSit();
        float f = Mth.m_14189_((float)p_115310_, (float)((VehicleEntity)((Object)p_115308_)).f_19859_, (float)p_115308_.m_146908_());
        float f1 = Mth.m_14189_((float)p_115310_, (float)((VehicleEntity)((Object)p_115308_)).f_19859_, (float)p_115308_.m_146908_());
        float f2 = f1 - f;
        if (shouldSit && p_115308_.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_115308_.m_20202_();
            f = Mth.m_14189_((float)p_115310_, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)p_115310_, (float)((VehicleEntity)((Object)p_115308_)).f_19860_, (float)p_115308_.m_146909_());
        float f7 = this.getBob(p_115308_, p_115310_);
        this.setupRotations(p_115308_, p_115311_, f7, f, p_115310_);
        p_115311_.m_85841_(-1.0f, -1.0f, 1.0f);
        this.scale(p_115308_, p_115311_, p_115310_);
        p_115311_.m_85837_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (p_115308_ instanceof RoverEntity) {
            f8 = Mth.m_14179_((float)p_115310_, (float)((RoverEntity)((Object)p_115308_)).animationSpeedOld, (float)((RoverEntity)((Object)p_115308_)).animationSpeed);
            f5 = ((RoverEntity)((Object)p_115308_)).animationPosition - ((RoverEntity)((Object)p_115308_)).animationSpeed * (1.0f - p_115310_);
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.model.m_6839_(p_115308_, f5, f8, p_115310_);
        this.model.m_6973_(p_115308_, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.isBodyVisible(p_115308_);
        boolean flag1 = !flag && !p_115308_.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_(p_115308_);
        RenderType rendertype = this.getRenderType(p_115308_, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = p_115312_.m_6299_(rendertype);
            int i = VehicleRenderer.getOverlayCoords(p_115308_, this.getWhiteOverlayProgress(p_115308_, p_115310_));
            this.model.m_7695_(p_115311_, vertexconsumer, p_115313_, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!p_115308_.m_5833_()) {
            for (RenderLayer<T, M> renderlayer : this.layers) {
                renderlayer.m_6494_(p_115311_, p_115312_, p_115313_, p_115308_, f5, f8, p_115310_, f7, f2, f6);
            }
        }
        p_115311_.m_85849_();
        super.m_7392_(p_115308_, p_115309_, p_115310_, p_115311_, p_115312_, p_115313_);
    }

    @Nullable
    protected RenderType getRenderType(T p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.m_5478_((Entity)p_115322_);
        if (p_115324_) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (p_115323_) {
            return this.model.m_103119_(resourcelocation);
        }
        return p_115325_ ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    protected boolean isBodyVisible(T p_115341_) {
        return !p_115341_.m_20145_();
    }

    protected boolean isShaking(T p_115304_) {
        return p_115304_.m_146890_();
    }

    public static int getOverlayCoords(Entity p_115339_, float p_115340_) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)p_115340_), (int)OverlayTexture.m_118096_((boolean)false));
    }

    protected float getWhiteOverlayProgress(T p_115334_, float p_115335_) {
        return 0.0f;
    }

    protected void setupRotations(T p_115317_, PoseStack p_115318_, float p_115319_, float p_115320_, float p_115321_) {
        Pose pose;
        if (this.isShaking(p_115317_)) {
            p_115320_ += (float)(Math.cos((double)((VehicleEntity)((Object)p_115317_)).f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = p_115317_.m_20089_()) != Pose.SLEEPING) {
            p_115318_.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - p_115320_));
        }
    }

    protected float getBob(T p_115305_, float p_115306_) {
        return (float)((VehicleEntity)((Object)p_115305_)).f_19797_ + p_115306_;
    }

    protected void scale(T p_115314_, PoseStack p_115315_, float p_115316_) {
    }
}

