/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.entity.alien;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.beyond_earth.crafting.AlienTradingRecipe;
import net.mrscauthd.beyond_earth.crafting.AlienTradingRecipeType;
import org.apache.commons.lang3.tuple.Triple;

public class AlienTrade
implements VillagerTrades.ItemListing {
    public static int MAX_USES = 9999;
    public static final Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>> TRADES = new HashMap<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>>();
    private AlienTradingRecipe recipe;

    public static void onAddReloadListener(AddReloadListenerEvent event) {
        AlienTrade.addReloadListener(event);
    }

    public static void registerTrades(RecipeManager recipeManager) {
        HashMap<VillagerProfession, Int2ObjectOpenHashMap> jobMap = new HashMap<VillagerProfession, Int2ObjectOpenHashMap>();
        VillagerProfession[] jobs = ForgeRegistries.PROFESSIONS.getValues().toArray(new VillagerProfession[0]);
        for (VillagerProfession job : jobs) {
            jobMap.put(job, new Int2ObjectOpenHashMap());
        }
        for (AlienTradingRecipeType alienTradingRecipeType : AlienTradingRecipeType.getTypes()) {
            List recipes = recipeManager.m_44013_((RecipeType)alienTradingRecipeType);
            for (AlienTradingRecipe recipe : recipes) {
                Int2ObjectMap listMap = (Int2ObjectMap)jobMap.get(recipe.getJob());
                ((List)listMap.computeIfAbsent(recipe.getLevel(), l -> new ArrayList())).add(new AlienTrade(recipe));
            }
        }
        Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>> map = TRADES;
        map.clear();
        for (Map.Entry entry : jobMap.entrySet()) {
            Int2ObjectMap listMap = map.computeIfAbsent((VillagerProfession)entry.getKey(), l -> new Int2ObjectOpenHashMap());
            Int2ObjectMap values = (Int2ObjectMap)entry.getValue();
            IntIterator intIterator = values.keySet().iterator();
            while (intIterator.hasNext()) {
                int level = (Integer)intIterator.next();
                List trades = (List)values.get(level);
                listMap.put(level, (Object)trades.toArray(new VillagerTrades.ItemListing[0]));
            }
        }
    }

    public static void addReloadListener(AddReloadListenerEvent event) {
        final RecipeManager recipeManager = event.getDataPackRegistries().m_136175_();
        event.addListener((PreparableReloadListener)new ResourceManagerReloadListener(){

            public void m_6213_(ResourceManager resourceManager) {
                AlienTrade.registerTrades(recipeManager);
            }
        });
    }

    private AlienTrade(AlienTradingRecipe recipe) {
        this.recipe = recipe;
    }

    public MerchantOffer m_5670_(Entity entity, Random random) {
        AlienTradingRecipe recipe = this.getRecipe();
        Triple<ItemStack, ItemStack, ItemStack> trade = recipe.getTrade(entity, random);
        return new MerchantOffer((ItemStack)trade.getLeft(), (ItemStack)trade.getMiddle(), (ItemStack)trade.getRight(), 0, recipe.getMaxUses(), recipe.getXP(), recipe.getPriceMultiplier());
    }

    public AlienTradingRecipe getRecipe() {
        return this.recipe;
    }
}

