/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.capability.oxygen;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.mrscauthd.beyond_earth.capability.oxygen.CapabilityOxygen;
import net.mrscauthd.beyond_earth.capability.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.capability.oxygen.IOxygenStorageHolder;
import net.mrscauthd.beyond_earth.capability.oxygen.OxygenStorage;

public class SpaceSuitCapabilityProvider
implements ICapabilityProvider,
IOxygenStorageHolder {
    public static final String KEY_OXYGEN = "Energy";
    private ItemStack itemStack;
    private IOxygenStorage oxygenStorage;

    public SpaceSuitCapabilityProvider(ItemStack itemStack, int capacity) {
        this.itemStack = itemStack;
        this.oxygenStorage = new OxygenStorage(this, capacity);
        this.readOxygen();
    }

    private void readOxygen() {
        CompoundTag compound = this.getItemStack().m_41784_();
        this.getOxygenStorage().setOxygenStored(compound.m_128451_(KEY_OXYGEN));
    }

    public void writeOxygen() {
        CompoundTag compound = this.getItemStack().m_41784_();
        compound.m_128405_(KEY_OXYGEN, this.getOxygenStorage().getOxygenStored());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
        if (capability == CapabilityOxygen.OXYGEN) {
            this.readOxygen();
            return LazyOptional.of(this::getOxygenStorage).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void onOxygenChanged(IOxygenStorage oxygenStorage, int oxygenDelta) {
        this.writeOxygen();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public IOxygenStorage getOxygenStorage() {
        return this.oxygenStorage;
    }
}

