/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.client.Localization;
import shetiphian.core.common.NameHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.network.NetworkHandler;
import shetiphian.endertanks.common.network.PacketTankInfo;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class TankInfoHelper {
    private static final TankInfoHelper INSTANCE = new TankInfoHelper();

    public static void sendTankInfo(Player player, String ownerName, String ownerID, String code) {
        String message = "\u00a76" + INSTANCE.localize("info.endertanks.bucket.header") + ":\u00a7r";
        List<String> contents = TankHelper.getTank(ownerID, code, player.m_20193_().f_46443_).getContentsInfo();
        for (String entry : contents) {
            message = message + entry + "<br>";
        }
        message = message + INSTANCE.infoTankOwner(ownerName, false, false);
        INSTANCE.sendInfo(player, message);
    }

    public static void sendTankInfo(Player player, TileEntityEnderTank tile) {
        String message = "\u00a76" + INSTANCE.localize("info.endertanks.tank.header") + ":\u00a7r";
        List<String> contents = tile.getEnderContainer().getContentsInfo();
        for (String entry : contents) {
            message = message + entry + "<br>";
        }
        message = message + INSTANCE.infoPump(tile.getPumpCapacity(), false);
        message = message + INSTANCE.infoTankOwner(tile.getOwnerName(), false, true);
        INSTANCE.sendInfo(player, message);
    }

    public static void getHUDInfo(List<String> tooltip, String ownerName, String code, int pump, List<String> contents) {
        for (String entry : contents) {
            tooltip.add("\u00a77" + entry + "\u00a7r");
        }
        tooltip.add("\u00a77" + INSTANCE.infoPump(pump, false) + "\u00a77");
        tooltip.add(INSTANCE.infoTankOwner(ownerName, true, false));
        tooltip.add(" " + Localization.get((String)"info.endertanks.tank.code") + " " + code);
    }

    public static void sendCapacityInfo(Player player, TileEntityEnderTank tankTile) {
        Object message = INSTANCE.localize("info.endertanks.tank.capacity");
        message = (String)message + " " + TankHelper.getTank(tankTile.getOwnerID(), tankTile.getCode(), tankTile.m_58904_().f_46443_).getCapacity();
        INSTANCE.sendInfo(player, (String)message);
    }

    public static void sendPumpInfo(Player player, TileEntityEnderTank tile) {
        Object message = INSTANCE.localize("info.endertanks.tank.pump.upgrade");
        message = (String)message + " " + tile.getPumpCapacity() + "mB";
        INSTANCE.sendInfo(player, (String)message);
    }

    public static void sendLinkError(Player player, int error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error.endertanks.bucket.nolink" + error) + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static void sendError(Player player, String error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error." + error) + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    private String infoPump(int capacity, boolean comma) {
        if (capacity >= 1000) {
            return (comma ? ", " : " ") + (float)capacity / 1000.0f + "K mB " + this.localize("info.endertanks.tank.pump");
        }
        return (comma ? ", " : " ") + capacity + "mB " + this.localize("info.endertanks.tank.pump");
    }

    private String infoTankOwner(String owner, boolean displayPublic, boolean comma) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            return displayPublic ? " \u00a76[-" + this.localize("info.endertanks.tank.public") + "-]\u00a7r" : "";
        }
        if (owner.startsWith("#")) {
            return (comma ? ", " : " ") + "\u00a7a[-" + owner.substring(1) + "\u00a7a-]\u00a7r";
        }
        return (comma ? ", " : " ") + "\u00a7b[-" + owner + "\u00a7b-]\u00a7r";
    }

    public static String formatTankOwner(String owner) {
        return INSTANCE.infoTankOwner(owner, false, false);
    }

    private String localize(String string) {
        return Localization.get((String)string);
    }

    private void sendInfo(Player player, String message) {
        if ((message = message.trim()).length() < 80) {
            if ((message = message.replace("<br>", ",")).endsWith(",")) {
                message = message.substring(0, message.length() - 1);
                message = message.trim();
            }
        } else {
            message = message.replace("<br>", "\u00c2\u00a6");
        }
        if (player instanceof ServerPlayer) {
            NetworkHandler.sendToPlayer(new PacketTankInfo(message), (ServerPlayer)player);
        } else {
            String[] split;
            for (String line : split = message.split("\u00c2\u00a6")) {
                player.m_5661_((Component)new TextComponent(line), true);
            }
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        if (ownerID.startsWith("#")) {
            return "#" + NameHelper.getDisplayNameFor((String)ownerID.substring(1));
        }
        return NameHelper.getDisplayNameFor((String)ownerID);
    }
}

