/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.capability.IFluidHandler;
import shetiphian.core.client.Localization;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.api.MissingHandlerEvent;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.misc.LocationManager;
import shetiphian.endertanks.common.misc.TankHelper;

public class EnderContainer
implements IEnderTankInfo {
    private final HashMap<String, ITankHandler<?>> handlers = new HashMap();
    private final HashMap<String, CompoundTag> missing_handlers = new HashMap();
    private final String owner;
    private final String code;
    private int capacity;

    public EnderContainer(String owner, String code) {
        this.capacity = (Integer)Configuration.UPGRADE_SETTINGS.tankSizeMin.get();
        this.owner = owner;
        this.code = code;
    }

    public void load(CompoundTag nbtTank) {
        if (nbtTank.m_128425_("Capacity", 2)) {
            this.capacity = Mth.m_14045_((int)nbtTank.m_128448_("Capacity"), (int)((Integer)Configuration.UPGRADE_SETTINGS.tankSizeMin.get()), (int)((Integer)Configuration.UPGRADE_SETTINGS.tankSizeMax.get()));
        }
        if (nbtTank.m_128425_("FluidName", 8)) {
            String key = HandlerRegistry.getKey(IFluidHandler.class);
            if (!nbtTank.m_128441_(key)) {
                CompoundTag nbtFluidHandler = new CompoundTag();
                nbtFluidHandler.m_128359_("FluidName", nbtTank.m_128461_("FluidName"));
                nbtFluidHandler.m_128405_("Amount", nbtTank.m_128451_("Amount"));
                if (nbtTank.m_128425_("Tag", 10)) {
                    nbtFluidHandler.m_128365_("Tag", (Tag)nbtTank.m_128469_("Tag"));
                }
                nbtTank.m_128365_(key, (Tag)nbtFluidHandler);
            }
            nbtTank.m_128473_("FluidName");
            nbtTank.m_128473_("Amount");
            nbtTank.m_128473_("Tag");
        }
        for (String key : nbtTank.m_128431_()) {
            if (nbtTank.m_128435_(key) != 10) continue;
            CompoundTag nbtData = nbtTank.m_128469_(key);
            ITankHandler<?> handler = HandlerRegistry.createHandlerFor(key, (IEnderTankInfo)this);
            if (handler != null) {
                handler.setCapacity(this.capacity);
                handler.load(nbtData);
                this.handlers.put(key, handler);
                continue;
            }
            MissingHandlerEvent event = new MissingHandlerEvent(key, nbtData);
            MinecraftForge.EVENT_BUS.post((Event)event);
            switch (event.getResult()) {
                case ALLOW: {
                    handler = HandlerRegistry.createHandlerFor(event.getProviderKey(), (IEnderTankInfo)this);
                    if (handler != null) {
                        handler.setCapacity(this.capacity);
                        handler.load(nbtData);
                        this.handlers.put(key, handler);
                        break;
                    }
                }
                case DEFAULT: {
                    this.missing_handlers.put(key, nbtData);
                    break;
                }
            }
        }
    }

    public CompoundTag save() {
        CompoundTag nbtHandler;
        CompoundTag nbtTank = new CompoundTag();
        if (this.capacity > (Integer)Configuration.UPGRADE_SETTINGS.tankSizeMin.get()) {
            nbtTank.m_128376_("Capacity", (short)this.capacity);
        }
        for (Map.Entry<String, ITankHandler<?>> entry : this.handlers.entrySet()) {
            nbtHandler = entry.getValue().save();
            if (nbtHandler == null || nbtHandler.m_128456_()) continue;
            nbtTank.m_128365_(entry.getKey(), (Tag)nbtHandler);
        }
        for (Map.Entry<String, ITankHandler<?>> entry : this.missing_handlers.entrySet()) {
            nbtHandler = (CompoundTag)entry.getValue();
            if (nbtHandler == null || nbtHandler.m_128456_()) continue;
            nbtTank.m_128365_(entry.getKey(), (Tag)nbtHandler);
        }
        return nbtTank;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        for (ITankHandler<?> handler : this.handlers.values()) {
            handler.setCapacity(capacity);
        }
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void notifyContentsChange() {
        TankHelper.needsSaving = true;
        LocationManager.doBlockUpdate(this.owner, this.code);
    }

    public ITankHandler<?> getOrCreateHandler(String key) {
        if (this.handlers.containsKey(key)) {
            return this.handlers.get(key);
        }
        ITankHandler<?> handler = HandlerRegistry.createHandlerFor(key, (IEnderTankInfo)this);
        if (handler != null) {
            this.handlers.put(key, handler);
        }
        return handler;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, StorageAccessMode access) {
        ITankHandler<?> handler = this.getOrCreateHandler(HandlerRegistry.getKey(capability));
        if (handler != null) {
            return LazyOptional.of(() -> handler.getTank(access)).cast();
        }
        return LazyOptional.empty();
    }

    public <T> T getTankFor(Capability<T> capability) {
        ITankHandler<?> handler = this.getOrCreateHandler(HandlerRegistry.getKey(capability));
        if (handler != null) {
            try {
                return (T)handler.getTank(StorageAccessMode.FULL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public <T> T getTankFor(Class<T> type) {
        ITankHandler<?> handler = this.getOrCreateHandler(HandlerRegistry.getKey(type));
        if (handler != null) {
            try {
                return (T)handler.getTank(StorageAccessMode.FULL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public List<String> getContentsInfo() {
        ArrayList<String> info = new ArrayList<String>();
        for (ITankHandler<?> handler : this.handlers.values()) {
            String entry = handler.getContentsInfo();
            if (Strings.isNullOrEmpty((String)entry)) continue;
            info.add(entry);
        }
        if (info.isEmpty()) {
            info.add(String.format(" %s [0/%sK mB]", Localization.get((String)"info.endertanks.tank.empty"), this.capacity));
        }
        return info;
    }
}

