/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.events;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.events.AddStructureToBiomeEvent;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.GelStructure;
import com.legacy.structure_gel.api.structure.base.IConfigStructure;
import com.legacy.structure_gel.api.util.GelCollectors;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.entity.GelCapability;
import com.legacy.structure_gel.core.capability.entity.GelEntityProvider;
import com.legacy.structure_gel.core.capability.entity.IGelEntity;
import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Internal
public class SGCommonEvents {
    public static void init(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(SGCommonEvents::commonInit);
        modBus.addListener(SGCommonEvents::loadComplete);
        modBus.addListener(SGCommonEvents::registerCapability);
        forgeBus.addListener(SGCommonEvents::registerCommands);
        forgeBus.addListener(SGCommonEvents::onEntityJoinLevel);
        forgeBus.addListener(SGCommonEvents::loadLevel);
        forgeBus.addGenericListener(Entity.class, SGCommonEvents::attachCapabilities);
    }

    protected static void commonInit(FMLCommonSetupEvent event) {
        PacketHandler.register();
    }

    protected static void loadComplete(FMLLoadCompleteEvent event) {
        try {
            if (SGConfig.COMMON.shouldGuessBiomeDict()) {
                StructureGelMod.log("Attempting to register unregistered biomes to the biome dictionary. This can be disabled via config", new Object[0]);
                BiomeDictionary.makeGuess();
            }
        }
        catch (Throwable e) {
            StructureGelMod.logError("Encountered an issue while making assumptions for the biome dictionary. Please narrow down which mods cause a conflict here and report it to our issue tracker: https://gitlab.com/modding-legacy/structure-gel-api/-/issues", new Object[0]);
            e.printStackTrace();
        }
        ForgeRegistries.STRUCTURE_FEATURES.forEach(structure -> {
            if (structure instanceof IConfigStructure) {
                IConfigStructure configStructure = (IConfigStructure)structure;
                StructureGelMod.debug("Reloading biome config for {}", structure.getRegistryName());
                configStructure.getConfig().reloadBiomes();
            }
        });
    }

    protected static void loadLevel(WorldEvent.Load event) {
        ServerLevel level;
        ChunkGenerator chunkGen;
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel && !((chunkGen = (level = (ServerLevel)levelAccessor).m_7726_().m_8481_()) instanceof FlatLevelSource)) {
            StructureSettings settings = chunkGen.m_62205_();
            ResourceLocation levelDimName = level.m_46472_().m_135782_();
            HashMap structures = new HashMap();
            MinecraftForge.EVENT_BUS.post((Event)new AddStructureToBiomeEvent((structure, biome) -> structures.computeIfAbsent(structure.f_65403_, s -> ImmutableMultimap.builder()).put(structure, biome)));
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll((Map)chunkGen.m_62205_().f_189361_);
            for (Map.Entry entry : ((ImmutableMap)structures.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ImmutableMultimap.Builder)e.getValue()).build()))).entrySet()) {
                if (chunkGen.m_62205_().f_189361_.containsKey(entry.getKey())) continue;
                builder.put(entry);
            }
            chunkGen.m_62205_().f_189361_ = builder.build();
            for (StructureRegistrar structureRegistrar : StructureRegistrar.REGISTRARS) {
                Object structure2 = structureRegistrar.getStructure();
                StructureFeatureConfiguration separation = structureRegistrar.getFeatureConfiguration();
                boolean shouldAddSettings = false;
                if (structure2 instanceof GelStructure) {
                    GelStructure gelStructure = (GelStructure)((Object)structure2);
                    Set<ResourceLocation> dims = gelStructure.getValidDimensions();
                    if (dims == null || dims.contains(levelDimName)) {
                        shouldAddSettings = true;
                    }
                } else {
                    shouldAddSettings = true;
                }
                if (!shouldAddSettings) continue;
                StructureGelMod.debug("Adding structure {} to dimension {}", structure2.m_67098_(), levelDimName.toString());
                settings.f_64582_ = GelCollectors.addToMap(settings.f_64582_, structure2, separation);
            }
        }
    }

    protected static void registerCapability(RegisterCapabilitiesEvent event) {
        event.register(IGelEntity.class);
    }

    protected static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (!((Entity)event.getObject()).getCapability(GelCapability.INSTANCE).isPresent()) {
            GelEntityProvider provider = new GelEntityProvider();
            event.addCapability(StructureGelMod.locate("gel_entity"), (ICapabilityProvider)provider);
        }
    }

    protected static void onEntityJoinLevel(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            GelCapability.ifPresent(serverPlayer, gelPlayer -> gelPlayer.sendToClient(serverPlayer));
        }
    }

    protected static void registerCommands(RegisterCommandsEvent event) {
        StructureGelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

