/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.google.common.collect.ImmutableMultimap;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.registries.ForgeRegistries;

public class GetStructuresCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"getstructures").executes(GetStructuresCommand::getStructures);
        return command;
    }

    public static int getStructures(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.m_81372_();
        Biome biome = level.m_46857_(new BlockPos(source.m_81371_()));
        ResourceLocation name = biome.getRegistryName();
        if (name != null) {
            source.m_81354_((Component)new TextComponent("[" + name.toString() + "]").m_130940_(ChatFormatting.GREEN), true);
            ArrayList structures = new ArrayList();
            ChunkGenerator chunkGen = level.m_7726_().m_8481_();
            for (StructureFeature structure : ForgeRegistries.STRUCTURE_FEATURES) {
                ImmutableMultimap map = chunkGen.m_62205_().m_189371_(structure);
                if (map.isEmpty()) continue;
                map.entries().stream().filter(e -> name.equals((Object)((ResourceKey)e.getValue()).m_135782_())).forEach(e -> structures.add((ConfiguredStructureFeature)e.getKey()));
            }
            if (structures.isEmpty()) {
                source.m_81354_((Component)new TextComponent(name.toString() + " has no structures."), true);
            } else {
                structures.forEach(supplier -> source.m_81354_((Component)new TextComponent(" - " + supplier.f_65403_.getRegistryName().toString()), true));
            }
            return structures.size();
        }
        source.m_81352_((Component)new TextComponent("The biome you're in doesn't have a registry name."));
        return 0;
    }
}

