/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class GetSpawnsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"getspawns").executes(context -> GetSpawnsCommand.getSpawns((CommandContext<CommandSourceStack>)context, MobCategory.values()));
        for (MobCategory category : MobCategory.values()) {
            command.then(Commands.m_82127_((String)category.m_21607_()).executes(context -> GetSpawnsCommand.getSpawns((CommandContext<CommandSourceStack>)context, category)));
        }
        return command;
    }

    private static int getSpawns(CommandContext<CommandSourceStack> context, MobCategory ... categories) {
        LinkedHashMap<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>> map = new LinkedHashMap<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>>();
        for (MobCategory category : categories) {
            WeightedRandomList<MobSpawnSettings.SpawnerData> list = GetSpawnsCommand.getSpawnList(context, category);
            if (list.m_146337_()) continue;
            map.put(category, list);
        }
        if (!map.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("--Spawn Data--"), true);
            map.entrySet().stream().sorted(new ClassificationComparator()).forEach(e -> GetSpawnsCommand.printSpawns(context, (MobCategory)e.getKey(), (WeightedRandomList<MobSpawnSettings.SpawnerData>)((WeightedRandomList)e.getValue())));
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("No spawn data."), true);
        }
        return 1;
    }

    private static WeightedRandomList<MobSpawnSettings.SpawnerData> getSpawnList(CommandContext<CommandSourceStack> context, MobCategory category) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockPos pos = new BlockPos(((CommandSourceStack)context.getSource()).m_81371_());
        Biome biome = level.m_46857_(pos);
        ServerChunkCache chunkSource = level.m_7726_();
        ChunkGenerator chunkGen = chunkSource.m_8481_();
        StructureFeatureManager manager = level.m_8595_();
        WeightedRandomList list = chunkGen.m_142184_(biome, manager, category, pos);
        return list;
    }

    private static void printSpawns(CommandContext<CommandSourceStack> context, MobCategory category, WeightedRandomList<MobSpawnSettings.SpawnerData> spawns) {
        if (!spawns.m_146337_()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[" + category.m_21607_() + "]").m_130940_(ChatFormatting.GREEN), true);
            spawns.m_146338_().stream().sorted(new SpawnInfoComparator()).forEach(spawn -> ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(String.format(" - %s, weight:%d, min:%d, max:%d", spawn.f_48404_.getRegistryName(), spawn.m_142631_().m_146281_(), spawn.f_48405_, spawn.f_48406_)), true));
        }
    }

    private static class ClassificationComparator<T extends Map.Entry<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>>>
    implements Comparator<T> {
        private ClassificationComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return ((MobCategory)o1.getKey()).m_21607_().compareTo(((MobCategory)o2.getKey()).m_21607_());
        }
    }

    private static class SpawnInfoComparator<T extends MobSpawnSettings.SpawnerData>
    implements Comparator<T> {
        private SpawnInfoComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return ((MobSpawnSettings.SpawnerData)o1).f_48404_.getRegistryName().toString().compareTo(((MobSpawnSettings.SpawnerData)o2).f_48404_.getRegistryName().toString());
        }
    }
}

