/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class GenerateStructureCommand {
    public static boolean overrideHeightmap = false;
    public static final SuggestionProvider<CommandSourceStack> STRUCTURES = SuggestionProviders.m_121658_((ResourceLocation)StructureGelMod.locate("structures"), (context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)BuiltinRegistries.f_123862_.m_6566_(), (SuggestionsBuilder)builder));

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"generatestructure").requires(source -> source.m_6761_(2));
        command.then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"structure", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(STRUCTURES).executes(context -> GenerateStructureCommand.generateStructure((CommandContext<CommandSourceStack>)context, BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), (ResourceLocation)context.getArgument("structure", ResourceLocation.class), null))).then(Commands.m_82129_((String)"seed", (ArgumentType)StringArgumentType.word()).executes(context -> GenerateStructureCommand.generateStructure((CommandContext<CommandSourceStack>)context, BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), (ResourceLocation)context.getArgument("structure", ResourceLocation.class), StringArgumentType.getString((CommandContext)context, (String)"seed"))))));
        return command;
    }

    private static int generateStructure(CommandContext<CommandSourceStack> context, BlockPos pos, ResourceLocation structureName, @Nullable String seedString) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Placing " + structureName.toString() + " at " + pos.m_123344_() + (String)(seedString != null ? " with seed " + seedString : "") + " ..."), true);
        ConfiguredStructureFeature structure = (ConfiguredStructureFeature)BuiltinRegistries.f_123862_.m_7745_(structureName);
        if (structure != null) {
            try {
                ChunkPos chunkPos = new ChunkPos(pos);
                ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
                ChunkGenerator chunkGen = level.m_7726_().m_8481_();
                StructureManager structureManager = level.m_8875_();
                StructureFeatureManager structureFeatureManager = level.m_8595_();
                int seed = seedString != null ? seedString.hashCode() : new Random().nextInt();
                StructureGelMod.log("Running \"/structure_gel generatestructure\". Temporarily changing how heightmaps work. If you encounter a crash during this time, this is why. Try not to generate chunks while this command is running.", new Object[0]);
                overrideHeightmap = true;
                int maxAttempts = 500;
                for (int attempt = 0; attempt <= maxAttempts; ++attempt) {
                    long seeed = seed + attempt * 40;
                    Optional optional = structure.f_65403_.f_191106_.m_197347_(new PieceGeneratorSupplier.Context(chunkGen, chunkGen.m_62218_(), seeed, chunkPos, structure.f_65404_, (LevelHeightAccessor)level, b -> true, structureManager, level.m_5962_()));
                    if (optional.isPresent()) {
                        Random rand = new Random(seeed);
                        StructurePiecesBuilder piecesBuilder = new StructurePiecesBuilder();
                        WorldgenRandom worldgenRand = new WorldgenRandom((RandomSource)new LegacyRandomSource(seeed));
                        worldgenRand.m_190068_(seeed, chunkPos.f_45578_, chunkPos.f_45579_);
                        ((PieceGenerator)optional.get()).m_197325_(piecesBuilder, new PieceGenerator.Context(structure.f_65404_, chunkGen, structureManager, chunkPos, (LevelHeightAccessor)level, worldgenRand, seeed));
                        overrideHeightmap = false;
                        StructureGelMod.log("Finished changing how heightmaps work.", new Object[0]);
                        StructureStart start = new StructureStart(structure.f_65403_, chunkPos, 0, piecesBuilder.m_192780_());
                        if (start.m_73603_()) {
                            for (Object piece : start.m_73602_()) {
                                if (!(piece instanceof StructurePiece)) continue;
                                StructurePiece structurePiece = (StructurePiece)piece;
                                structurePiece.m_183269_((WorldGenLevel)level, structureFeatureManager, chunkGen, rand, BoundingBox.m_71044_(), chunkPos, pos);
                            }
                        }
                        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Finished placing " + structureName.toString()), true);
                        System.out.println(attempt);
                        break;
                    }
                    if (attempt != maxAttempts) continue;
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Failed to place " + structureName.toString() + ". Try at another location or with a different seed."));
                }
                if (overrideHeightmap) {
                    StructureGelMod.log("Finished changing how heightmaps work.", new Object[0]);
                    overrideHeightmap = false;
                }
            }
            catch (Throwable e) {
                overrideHeightmap = false;
                String message = "Encountered an error while placing " + structureName.toString();
                ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent(message));
                StructureGelMod.logError(message, e);
                return 0;
            }
            overrideHeightmap = false;
            return 1;
        }
        overrideHeightmap = false;
        return 0;
    }
}

