/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;

public class BiomeDictCommand {
    public static final SuggestionProvider<CommandSourceStack> BIOME_DICTIONARY_ENTRIES = SuggestionProviders.m_121658_((ResourceLocation)StructureGelMod.locate("biome_dictionary_entries"), (context, builder) -> SharedSuggestionProvider.m_82926_(BiomeDictionary.REGISTRY.keySet(), (SuggestionsBuilder)builder));

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"biomedict");
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"gettypes").executes(BiomeDictCommand::getTypes)).then(Commands.m_82129_((String)"biome", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SuggestionProviders.f_121644_).executes(context -> BiomeDictCommand.getTypes((CommandContext<CommandSourceStack>)context, (ResourceLocation)context.getArgument("biome", ResourceLocation.class)))));
        command.then(Commands.m_82127_((String)"getbiomes").then(Commands.m_82129_((String)"dictionaryentry", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(BIOME_DICTIONARY_ENTRIES).executes(context -> BiomeDictCommand.getBiomes((CommandContext<CommandSourceStack>)context, (ResourceLocation)context.getArgument("dictionaryentry", ResourceLocation.class)))));
        return command;
    }

    private static int getTypes(CommandContext<CommandSourceStack> context) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        Optional biome = level.m_5962_().m_175515_(Registry.f_122885_).m_7854_((Object)level.m_46857_(new BlockPos(((CommandSourceStack)context.getSource()).m_81371_())));
        if (biome.isPresent()) {
            return BiomeDictCommand.getTypes(context, ((ResourceKey)biome.get()).m_135782_());
        }
        return 0;
    }

    private static int getTypes(CommandContext<CommandSourceStack> context, ResourceLocation key) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[" + key.toString() + "]").m_130940_(ChatFormatting.GREEN), true);
        List<String> types = BiomeDictionary.getAllTypes((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)key)).stream().map(b -> b.getRegistryName().toString()).sorted().collect(Collectors.toList());
        if (types.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(key.toString() + " has no registered types."), true);
        } else {
            types.forEach(t -> ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(" - " + t), true));
        }
        return 1;
    }

    private static int getBiomes(CommandContext<CommandSourceStack> context, ResourceLocation key) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("[" + key.toString() + "]").m_130940_(ChatFormatting.GREEN), true);
        List<String> biomes = BiomeDictionary.REGISTRY.get(key).getAllBiomes().stream().map(rk -> rk.m_135782_().toString()).sorted().collect(Collectors.toList());
        if (biomes.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(key.toString() + " has no registered biomes."), true);
        } else {
            biomes.forEach(b -> ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(" - " + b), true));
        }
        return 1;
    }
}

