/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public abstract class GelStructure<C extends FeatureConfiguration>
extends StructureFeature<C> {
    protected Map<MobCategory, List<MobSpawnSettings.SpawnerData>> spawns = new HashMap<MobCategory, List<MobSpawnSettings.SpawnerData>>();
    protected Integer seed = null;
    protected int offset = -1;

    public GelStructure(Codec<C> codec, PieceGenerator<C> generator) {
        this(codec, PieceGeneratorSupplier.m_197349_((Predicate)PieceGeneratorSupplier.m_197345_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG), generator));
    }

    public GelStructure(Codec<C> codec, PieceGeneratorSupplier<C> pieceGeneratorSupplier) {
        this(codec, pieceGeneratorSupplier, PostPlacementProcessor.f_192427_);
    }

    public GelStructure(Codec<C> codec, PieceGeneratorSupplier<C> pieceGeneratorSupplier, PostPlacementProcessor postPlacementProcessor) {
        super(codec, pieceGeneratorSupplier, postPlacementProcessor);
        this.setPieceGenerator(original -> context -> {
            if (this.isFeatureChunk(context.f_197354_(), context.f_197355_())) {
                return original.m_197347_(context);
            }
            return Optional.empty();
        });
        this.setLakeProof(true);
    }

    protected void setPieceGenerator(Function<PieceGeneratorSupplier<C>, PieceGeneratorSupplier<C>> newPieceGeneratorFunction) {
        this.f_191106_ = newPieceGeneratorFunction.apply(this.f_191106_);
    }

    public void setLakeProof(boolean lakeProof) {
        if (lakeProof) {
            StructureAccessHelper.addLakeProofStructure(this);
        } else {
            StructureAccessHelper.removeLakeProofStructure(this);
        }
    }

    public int getSeed() {
        if (this.seed == null) {
            if (this.getRegistryName() == null) {
                this.seed = Math.abs(((Object)((Object)this)).getClass().getCanonicalName().hashCode());
                StructureGelMod.logWarn("The structure {} does not have a registry name. Seed defaulted to {}. This should be avoided.", ((Object)((Object)this)).getClass().getName(), this.seed);
            } else {
                this.seed = Math.abs(this.getRegistryName().toString().hashCode());
            }
        }
        return this.seed;
    }

    public float getProbability() {
        return 1.0f;
    }

    public abstract int getSpacing();

    public int getOffset() {
        return this.getSpacing() - 2;
    }

    @Internal
    private int getSafeOffset() {
        if (this.offset < 0) {
            this.offset = Mth.m_14045_((int)(this.getOffset() - 2), (int)0, (int)this.getSpacing());
        }
        return this.offset;
    }

    @Nullable
    public Set<ResourceLocation> getValidDimensions() {
        return null;
    }

    public boolean isAllowedNearWorldSpawn() {
        return false;
    }

    public List<MobSpawnSettings.SpawnerData> getDefaultSpawnList(MobCategory category) {
        return this.spawns.getOrDefault(category, new ArrayList());
    }

    public ChunkPos m_191122_(@Nullable StructureFeatureConfiguration settings, long seed, int chunkX, int chunkZ) {
        int spacing = this.getSpacing();
        int gridX = (int)Math.floor((float)chunkX / (float)spacing) * spacing;
        int gridZ = (int)Math.floor((float)chunkZ / (float)spacing) * spacing;
        int offset = this.getSafeOffset() + 1;
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        rand.m_190058_(seed, gridX, gridZ, this.getSeed());
        return new ChunkPos(gridX + rand.nextInt(offset), gridZ + rand.nextInt(offset));
    }

    protected boolean isFeatureChunk(long seed, ChunkPos chunkPos) {
        int z;
        int range;
        int x;
        if (!this.isAllowedNearWorldSpawn() && (x = chunkPos.f_45578_) < (range = 12) && x > -range && (z = chunkPos.f_45579_) < range && z > -range) {
            return false;
        }
        float probability = this.getProbability();
        if (probability == 1.0f) {
            return true;
        }
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(seed));
        rand.m_190058_(seed, chunkPos.f_45578_, chunkPos.f_45579_, this.getSeed());
        return rand.nextFloat() < probability;
    }

    @Internal
    public final BlockPos m_67046_(LevelReader level, StructureFeatureManager structureManager, BlockPos startPos, int searchRadius, boolean skipExistingChunks, long seed, @Nullable StructureFeatureConfiguration settings) {
        if (this.getProbability() == 0.0f) {
            return null;
        }
        return super.m_67046_(level, structureManager, startPos, searchRadius, skipExistingChunks, seed, this.getFeatureConfiguration());
    }

    @Internal
    public StructureFeatureConfiguration getFeatureConfiguration() {
        return new StructureFeatureConfiguration(this.getSpacing(), this.getSafeOffset(), this.getSeed());
    }
}

