/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.events;

import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.base.IConfigStructure;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;

public class AddStructureToBiomeEvent
extends Event
implements IModBusEvent {
    private final BiConsumer<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> registerFunc;

    public AddStructureToBiomeEvent(BiConsumer<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> registerFunc) {
        this.registerFunc = registerFunc;
    }

    public void register(ConfiguredStructureFeature<?, ?> configuredStructure, ResourceKey<Biome> biome) {
        this.registerFunc.accept(configuredStructure, biome);
    }

    public void register(ConfiguredStructureFeature<?, ?> configuredStructure, Set<ResourceKey<Biome>> biomes) {
        biomes.forEach(biome -> this.register(configuredStructure, (ResourceKey<Biome>)biome));
    }

    public void register(ConfiguredStructureFeature<?, ?> configuredStructure, BiomeType biomeType) {
        this.register(configuredStructure, biomeType.getAllBiomes());
    }

    public void register(StructureRegistrar<?, ?> structureRegistrar, ResourceKey<Biome> biome) {
        this.register(structureRegistrar.getStructureFeature(), biome);
    }

    public void register(StructureRegistrar<?, ?> structureRegistrar, Set<ResourceKey<Biome>> biomes) {
        this.register(structureRegistrar.getStructureFeature(), biomes);
    }

    public <S extends StructureFeature<?>> void register(StructureRegistrar<?, S> structureRegistrar) {
        this.register(structureRegistrar.getStructureFeature());
    }

    public <S extends StructureFeature<?>> void register(ConfiguredStructureFeature<?, S> gelConfigStructure) {
        Set<ResourceKey<Biome>> biomes = ((IConfigStructure)gelConfigStructure.f_65403_).getConfig().getBiomes().stream().map(name -> ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)name)).collect(Collectors.toSet());
        this.register(gelConfigStructure, biomes);
    }
}

