/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.common;

import fr.mrcraftcod.fallingtree.common.FallingTreeCommon;
import fr.mrcraftcod.fallingtree.common.leaf.LeafBreakingHandler;
import fr.mrcraftcod.fallingtree.common.wrapper.DirectionCompat;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlock;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlockPos;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlockState;
import fr.mrcraftcod.fallingtree.common.wrapper.IComponent;
import fr.mrcraftcod.fallingtree.common.wrapper.IItem;
import fr.mrcraftcod.fallingtree.common.wrapper.ILevel;
import fr.mrcraftcod.fallingtree.common.wrapper.IPlayer;
import fr.raksrinana.fallingtree.fabric.common.wrapper.BlockWrapper;
import fr.raksrinana.fallingtree.fabric.common.wrapper.ComponentWrapper;
import fr.raksrinana.fallingtree.fabric.common.wrapper.ItemWrapper;
import fr.raksrinana.fallingtree.fabric.event.BlockBreakListener;
import fr.raksrinana.fallingtree.fabric.event.LeafBreakingListener;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class FallingTreeCommonsImpl
extends FallingTreeCommon<class_2350> {
    private final LeafBreakingHandler leafBreakingHandler = new LeafBreakingHandler(this);

    @Override
    @NotNull
    public IComponent translate(@NotNull String key, Object ... objects) {
        return new ComponentWrapper((class_5250)new class_2588(key, objects));
    }

    @Override
    @NotNull
    public LeafBreakingHandler getLeafBreakingHandler() {
        return this.leafBreakingHandler;
    }

    @Override
    @NotNull
    public Stream<IBlock> getBlock(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            class_2960 identifier = new class_2960(name);
            if (isTag) {
                return TagFactory.BLOCK.create(identifier).method_15138().stream().map(BlockWrapper::new);
            }
            return Stream.of((class_2248)class_2378.field_11146.method_10223(identifier)).map(BlockWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    @NotNull
    public Stream<IItem> getItem(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            class_2960 identifier = new class_2960(name);
            if (isTag) {
                return TagFactory.ITEM.create(identifier).method_15138().stream().map(ItemWrapper::new);
            }
            return Stream.of((class_1792)class_2378.field_11142.method_10223(identifier)).map(ItemWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public boolean isLeafBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = class_3481.field_15503.method_15141((Object)((class_2248)block.getRaw())) || this.getConfiguration().getTrees().getAllowedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    public boolean isLogBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = this.getConfiguration().getTrees().getDefaultLogsBlocks(this).stream().anyMatch(log -> log.equals(block)) || this.getConfiguration().getTrees().getAllowedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<IBlock> getAllNonStrippedLogsBlocks() {
        return class_3481.field_15475.method_15138().stream().filter(block -> Optional.of(class_2378.field_11146.method_10221(block)).map(class_2960::method_12832).map(name -> name.startsWith("stripped")).orElse(false) == false).map(BlockWrapper::new).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public DirectionCompat asDirectionCompat(@NotNull class_2350 dir) {
        return DirectionCompat.valueOf(dir.name());
    }

    @Override
    @NotNull
    public class_2350 asDirection(@NotNull DirectionCompat dir) {
        return class_2350.valueOf((String)dir.name());
    }

    @Override
    public boolean isNetherWartOrShroomlight(@NotNull IBlock block) {
        return class_3481.field_21954.method_15141((Object)((class_2248)block.getRaw())) || class_2246.field_22122.equals(block.getRaw());
    }

    @Override
    public boolean checkCanBreakBlock(@NotNull ILevel level, @NotNull IBlockPos blockPos, @NotNull IBlockState blockState, @NotNull IPlayer player) {
        return true;
    }

    public void register() {
        ServerTickEvents.END_SERVER_TICK.register((Object)new LeafBreakingListener(this));
        PlayerBlockBreakEvents.BEFORE.register((Object)new BlockBreakListener(this));
    }
}

