/*
 * Decompiled with CFR 0.152.
 */
package fr.mrcraftcod.fallingtree.common.config.cloth;

import fr.mrcraftcod.fallingtree.common.FallingTreeCommon;
import fr.mrcraftcod.fallingtree.common.wrapper.IComponent;
import java.lang.invoke.CallSite;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClothHookBase {
    private static final Pattern MINECRAFT_ID_PATTERN = Pattern.compile("#?[a-z0-9_.-]+:[a-z0-9/._-]+");
    @NotNull
    private final FallingTreeCommon<?> mod;

    @NotNull
    protected String getFieldName(@Nullable String category, @NotNull String fieldName) {
        return Optional.ofNullable(category).filter(c -> !c.isBlank()).map(c -> "text.autoconfig.fallingtree.option." + c + "." + fieldName).orElseGet(() -> "text.autoconfig.fallingtree.option." + fieldName);
    }

    @NotNull
    protected Stream<IComponent> getTooltipsInternal(@Nullable String category, @NotNull String fieldName, int count) {
        String tooltipKey = this.getFieldName(category, fieldName) + ".@Tooltip";
        LinkedList<CallSite> keys = new LinkedList<CallSite>();
        if (count <= 1) {
            keys.add((CallSite)((Object)tooltipKey));
        } else {
            for (int i = 0; i < count; ++i) {
                keys.add((CallSite)((Object)(tooltipKey + "[" + i + "]")));
            }
        }
        return keys.stream().map(x$0 -> this.mod.translate((String)x$0, new Object[0]));
    }

    @NotNull
    protected Function<String, Optional<IComponent>> getMinecraftBlockIdCellError() {
        return value -> Optional.ofNullable(value).map(v -> MINECRAFT_ID_PATTERN.matcher((CharSequence)v).matches()).filter(v -> v == false).map(v -> this.mod.translate("text.autoconfig.fallingtree.error.invalidBlockResourceLocation", new Object[0]));
    }

    @NotNull
    protected Function<String, Optional<IComponent>> getMinecraftItemIdCellError() {
        return value -> Optional.ofNullable(value).map(v -> MINECRAFT_ID_PATTERN.matcher((CharSequence)v).matches()).filter(v -> v == false).map(v -> this.mod.translate("text.autoconfig.fallingtree.error.invalidItemResourceLocation", new Object[0]));
    }

    public ClothHookBase(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }

    @NotNull
    protected FallingTreeCommon<?> getMod() {
        return this.mod;
    }
}

