/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util.box;

import com.jozufozu.flywheel.util.RenderMath;
import com.jozufozu.flywheel.util.box.CoordinateConsumer;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import net.minecraft.world.phys.AABB;

public interface ImmutableBox {
    public int getMinX();

    public int getMinY();

    public int getMinZ();

    public int getMaxX();

    public int getMaxY();

    public int getMaxZ();

    default public int sizeX() {
        return this.getMaxX() - this.getMinX();
    }

    default public int sizeY() {
        return this.getMaxY() - this.getMinY();
    }

    default public int sizeZ() {
        return this.getMaxZ() - this.getMinZ();
    }

    default public int volume() {
        return this.sizeX() * this.sizeY() * this.sizeZ();
    }

    default public boolean empty() {
        return this.getMinX() == this.getMaxX() || this.getMinY() == this.getMaxY() || this.getMinZ() == this.getMaxZ();
    }

    default public boolean sameAs(ImmutableBox other) {
        return this.getMinX() == other.getMinX() && this.getMinY() == other.getMinY() && this.getMinZ() == other.getMinZ() && this.getMaxX() == other.getMaxX() && this.getMaxY() == other.getMaxY() && this.getMaxZ() == other.getMaxZ();
    }

    default public boolean sameAs(AABB other) {
        return (double)this.getMinX() == Math.floor(other.f_82288_) && (double)this.getMinY() == Math.floor(other.f_82289_) && (double)this.getMinZ() == Math.floor(other.f_82290_) && (double)this.getMaxX() == Math.ceil(other.f_82291_) && (double)this.getMaxY() == Math.ceil(other.f_82292_) && (double)this.getMaxZ() == Math.ceil(other.f_82293_);
    }

    default public boolean hasPowerOf2Sides() {
        return RenderMath.isPowerOf2(this.volume());
    }

    default public GridAlignedBB intersect(ImmutableBox other) {
        int minX = Math.max(this.getMinX(), other.getMinX());
        int minY = Math.max(this.getMinY(), other.getMinY());
        int minZ = Math.max(this.getMinZ(), other.getMinZ());
        int maxX = Math.min(this.getMaxX(), other.getMaxX());
        int maxY = Math.min(this.getMaxY(), other.getMaxY());
        int maxZ = Math.min(this.getMaxZ(), other.getMaxZ());
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    default public ImmutableBox union(ImmutableBox other) {
        int minX = Math.min(this.getMinX(), other.getMinX());
        int minY = Math.min(this.getMinY(), other.getMinY());
        int minZ = Math.min(this.getMinZ(), other.getMinZ());
        int maxX = Math.max(this.getMaxX(), other.getMaxX());
        int maxY = Math.max(this.getMaxY(), other.getMaxY());
        int maxZ = Math.max(this.getMaxZ(), other.getMaxZ());
        return new GridAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    default public boolean intersects(ImmutableBox other) {
        return this.intersects(other.getMinX(), other.getMinY(), other.getMinZ(), other.getMaxX(), other.getMaxY(), other.getMaxZ());
    }

    default public boolean contains(int x, int y, int z) {
        return x >= this.getMinX() && x <= this.getMaxX() && y >= this.getMinY() && y <= this.getMaxY() && z >= this.getMinZ() && z <= this.getMaxZ();
    }

    default public boolean contains(ImmutableBox other) {
        return other.getMinX() >= this.getMinX() && other.getMaxX() <= this.getMaxX() && other.getMinY() >= this.getMinY() && other.getMaxY() <= this.getMaxY() && other.getMinZ() >= this.getMinZ() && other.getMaxZ() <= this.getMaxZ();
    }

    default public boolean isContainedBy(GridAlignedBB other) {
        return other.contains(this);
    }

    default public boolean intersects(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return this.getMinX() < maxX && this.getMaxX() > minX && this.getMinY() < maxY && this.getMaxY() > minY && this.getMinZ() < maxZ && this.getMaxZ() > minZ;
    }

    default public void forEachContained(CoordinateConsumer func) {
        if (this.empty()) {
            return;
        }
        for (int x = this.getMinX(); x < this.getMaxX(); ++x) {
            for (int y = this.getMinY(); y < this.getMaxY(); ++y) {
                for (int z = this.getMinZ(); z < this.getMaxZ(); ++z) {
                    func.consume(x, y, z);
                }
            }
        }
    }

    default public AABB toAABB() {
        return new AABB((double)this.getMinX(), (double)this.getMinY(), (double)this.getMinZ(), (double)this.getMaxX(), (double)this.getMaxY(), (double)this.getMaxZ());
    }

    default public GridAlignedBB copy() {
        return new GridAlignedBB(this.getMinX(), this.getMinY(), this.getMinZ(), this.getMaxX(), this.getMaxY(), this.getMaxZ());
    }
}

