/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util;

import com.jozufozu.flywheel.util.NonNullSupplier;
import com.jozufozu.flywheel.util.Pair;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class Lazy<T> {
    private final NonNullSupplier<T> supplier;
    private T value;

    public Lazy(NonNullSupplier<T> supplier) {
        this.supplier = supplier;
    }

    @Nonnull
    public T get() {
        if (this.value == null) {
            this.value = this.supplier.get();
        }
        return this.value;
    }

    public static <T> Pair<Lazy<T>, KillSwitch<T>> ofKillable(NonNullSupplier<T> factory, Consumer<T> destructor) {
        Lazy<T> lazy = new Lazy<T>(factory);
        KillSwitch<T> killSwitch = new KillSwitch<T>(lazy, destructor);
        return Pair.of(lazy, killSwitch);
    }

    public static <T> Lazy<T> of(NonNullSupplier<T> factory) {
        return new Lazy<T>(factory);
    }

    public static class KillSwitch<T> {
        private final Lazy<T> lazy;
        private final Consumer<T> finalizer;

        private KillSwitch(Lazy<T> lazy, Consumer<T> finalizer) {
            this.lazy = lazy;
            this.finalizer = finalizer;
        }

        public void killValue() {
            if (this.lazy.value != null) {
                this.finalizer.accept(this.lazy.value);
                this.lazy.value = null;
            }
        }
    }
}

