/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.light;

import com.jozufozu.flywheel.light.BasicProvider;
import com.jozufozu.flywheel.light.LightListener;
import com.jozufozu.flywheel.light.LightProvider;
import com.jozufozu.flywheel.light.MovingListener;
import com.jozufozu.flywheel.light.WeakContainmentMultiMap;
import com.jozufozu.flywheel.util.WeakHashSet;
import com.jozufozu.flywheel.util.box.GridAlignedBB;
import com.jozufozu.flywheel.util.box.ImmutableBox;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;

public class LightUpdater {
    private static final Map<BlockAndTintGetter, LightUpdater> light = new HashMap<BlockAndTintGetter, LightUpdater>();
    private final LightProvider provider;
    private final WeakHashSet<MovingListener> movingListeners = new WeakHashSet();
    private final WeakContainmentMultiMap<LightListener> sections = new WeakContainmentMultiMap();
    private final WeakContainmentMultiMap<LightListener> chunks = new WeakContainmentMultiMap();

    public static LightUpdater get(BlockAndTintGetter world) {
        return light.computeIfAbsent(world, LightUpdater::new);
    }

    public LightUpdater(BlockAndTintGetter world) {
        this.provider = new BasicProvider(world);
    }

    public LightProvider getProvider() {
        return this.provider;
    }

    public void tick() {
        for (MovingListener listener : this.movingListeners) {
            if (!listener.update(this.provider)) continue;
            this.addListener(listener);
        }
    }

    public void addListener(LightListener listener) {
        if (listener instanceof MovingListener) {
            this.movingListeners.add((MovingListener)listener);
        }
        ImmutableBox box = listener.getVolume();
        LongSet sections = this.sections.getAndResetContainment(listener);
        LongSet chunks = this.chunks.getAndResetContainment(listener);
        int minX = SectionPos.m_123171_((int)box.getMinX());
        int minY = SectionPos.m_123171_((int)box.getMinY());
        int minZ = SectionPos.m_123171_((int)box.getMinZ());
        int maxX = SectionPos.m_123171_((int)box.getMaxX());
        int maxY = SectionPos.m_123171_((int)box.getMaxY());
        int maxZ = SectionPos.m_123171_((int)box.getMaxZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    long sectionPos = SectionPos.m_123209_((int)x, (int)y, (int)z);
                    this.sections.put(sectionPos, listener);
                    sections.add(sectionPos);
                }
                long chunkPos = SectionPos.m_123209_((int)x, (int)0, (int)z);
                this.chunks.put(chunkPos, listener);
                chunks.add(chunkPos);
            }
        }
    }

    public void removeListener(LightListener listener) {
        this.sections.remove(listener);
        this.chunks.remove(listener);
    }

    public void onLightUpdate(LightLayer type, long sectionPos) {
        Set<LightListener> set = this.sections.get(sectionPos);
        if (set == null || set.isEmpty()) {
            return;
        }
        set.removeIf(l -> l.status().shouldRemove());
        GridAlignedBB chunkBox = GridAlignedBB.from(SectionPos.m_123184_((long)sectionPos));
        for (LightListener listener : set) {
            listener.onLightUpdate(this.provider, type, chunkBox);
        }
    }

    public void onLightPacket(int chunkX, int chunkZ) {
        long chunkPos = SectionPos.m_123209_((int)chunkX, (int)0, (int)chunkZ);
        Set<LightListener> set = this.chunks.get(chunkPos);
        if (set == null || set.isEmpty()) {
            return;
        }
        set.removeIf(l -> l.status().shouldRemove());
        for (LightListener listener : set) {
            listener.onLightPacket(this.provider, chunkX, chunkZ);
        }
    }

    public static long blockToSection(BlockPos pos) {
        return SectionPos.m_123209_((int)pos.m_123341_(), (int)pos.m_123342_(), (int)pos.m_123343_());
    }

    public static long sectionToChunk(long sectionPos) {
        return sectionPos & 0xFFFFFFFFFFF00000L;
    }

    public Stream<ImmutableBox> getAllBoxes() {
        return this.chunks.stream().map(LightListener::getVolume);
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }
}

