/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.util.RenderMath;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;

public class BlockVertexList
implements VertexList {
    private final ByteBuffer buffer;
    private final int vertexCount;
    private final int stride;

    public BlockVertexList(BufferBuilder builder) {
        Pair data = builder.m_85728_();
        this.buffer = (ByteBuffer)data.getSecond();
        this.stride = builder.getVertexFormat().m_86020_();
        this.vertexCount = ((BufferBuilder.DrawState)data.getFirst()).m_85746_();
    }

    @Override
    public boolean isEmpty() {
        return this.vertexCount == 0;
    }

    private int vertIdx(int vertexIndex) {
        return vertexIndex * this.stride;
    }

    @Override
    public float getX(int index) {
        return this.buffer.getFloat(this.vertIdx(index));
    }

    @Override
    public float getY(int index) {
        return this.buffer.getFloat(this.vertIdx(index) + 4);
    }

    @Override
    public float getZ(int index) {
        return this.buffer.getFloat(this.vertIdx(index) + 8);
    }

    @Override
    public byte getR(int index) {
        return this.buffer.get(this.vertIdx(index) + 12);
    }

    @Override
    public byte getG(int index) {
        return this.buffer.get(this.vertIdx(index) + 13);
    }

    @Override
    public byte getB(int index) {
        return this.buffer.get(this.vertIdx(index) + 14);
    }

    @Override
    public byte getA(int index) {
        return this.buffer.get(this.vertIdx(index) + 15);
    }

    @Override
    public float getU(int index) {
        return this.buffer.getFloat(this.vertIdx(index) + 16);
    }

    @Override
    public float getV(int index) {
        return this.buffer.getFloat(this.vertIdx(index) + 20);
    }

    @Override
    public int getLight(int index) {
        return this.buffer.getInt(this.vertIdx(index) + 24);
    }

    @Override
    public float getNX(int index) {
        return RenderMath.f(this.buffer.get(this.vertIdx(index) + 28));
    }

    @Override
    public float getNY(int index) {
        return RenderMath.f(this.buffer.get(this.vertIdx(index) + 29));
    }

    @Override
    public float getNZ(int index) {
        return RenderMath.f(this.buffer.get(this.vertIdx(index) + 30));
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }
}

