/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source.parse;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.core.source.parse.AbstractShaderElement;
import com.jozufozu.flywheel.core.source.parse.Variable;
import com.jozufozu.flywheel.core.source.span.Span;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ShaderFunction
extends AbstractShaderElement {
    public static final Pattern argument = Pattern.compile("(?:(inout|in|out) )?(\\w+)\\s+(\\w+)");
    public static final Pattern assignment = Pattern.compile("(\\w+)\\s*=");
    private final Span type;
    private final Span name;
    private final Span args;
    private final Span body;
    private final ImmutableList<Variable> parameters;

    public ShaderFunction(Span self, Span type, Span name, Span args, Span body) {
        super(self);
        this.type = type;
        this.name = name;
        this.args = args;
        this.body = body;
        this.parameters = this.parseArguments();
    }

    public Span getType() {
        return this.type;
    }

    public Span getName() {
        return this.name;
    }

    public Span getArgs() {
        return this.args;
    }

    public Span getBody() {
        return this.body;
    }

    public String call(String ... args) {
        return this.name + "(" + String.join((CharSequence)", ", args) + ")";
    }

    public ImmutableList<Variable> getParameters() {
        return this.parameters;
    }

    public String returnTypeName() {
        return this.type.get();
    }

    protected ImmutableList<Variable> parseArguments() {
        if (this.args.isErr() || this.args.isEmpty()) {
            return ImmutableList.of();
        }
        Matcher arguments = argument.matcher(this.args.get());
        ImmutableList.Builder builder = ImmutableList.builder();
        while (arguments.find()) {
            Span self = Span.fromMatcher(this.args, arguments);
            Span qualifier = Span.fromMatcher(this.args, arguments, 1);
            Span type = Span.fromMatcher(this.args, arguments, 2);
            Span name = Span.fromMatcher(this.args, arguments, 3);
            builder.add((Object)new Variable(self, qualifier, type, name));
        }
        return builder.build();
    }

    public String toString() {
        String p = this.parameters.stream().map(variable -> variable.type).map(Span::get).collect(Collectors.joining(","));
        return this.type + " " + this.name + "(" + p + ")";
    }
}

