/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShaderConstants {
    private final Map<String, String> definitions = new HashMap<String, String>();

    public ShaderConstants define(String def) {
        this.definitions.put(def, "");
        return this;
    }

    public ShaderConstants define(String def, String value) {
        this.definitions.put(def, value);
        return this;
    }

    public ShaderConstants define(String def, float value) {
        this.definitions.put(def, Float.toString(value));
        return this;
    }

    public ShaderConstants defineAll(List<String> defines) {
        for (String def : defines) {
            this.definitions.put(def, "");
        }
        return this;
    }

    public String build() {
        StringBuilder acc = new StringBuilder();
        this.writeInto(acc);
        return acc.toString();
    }

    public void writeInto(StringBuilder acc) {
        for (Map.Entry<String, String> e : this.definitions.entrySet()) {
            acc.append("#define ").append(e.getKey());
            if (e.getValue().length() > 0) {
                acc.append(' ').append(e.getValue());
            }
            acc.append('\n');
        }
    }
}

