/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.materials.model;

import com.jozufozu.flywheel.core.materials.BasicData;
import com.jozufozu.flywheel.util.transform.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import net.minecraft.util.Mth;

public class ModelData
extends BasicData
implements Transform<ModelData> {
    public final Matrix4f model = new Matrix4f();
    public final Matrix3f normal = new Matrix3f();

    public ModelData setTransform(PoseStack stack) {
        this.markDirty();
        this.model.m_162210_(stack.m_85850_().m_85861_());
        this.normal.m_8169_(stack.m_85850_().m_85864_());
        return this;
    }

    public ModelData setEmptyTransform() {
        this.markDirty();
        this.model.m_162210_(new Matrix4f());
        this.normal.m_8169_(new Matrix3f());
        return this;
    }

    public ModelData loadIdentity() {
        this.markDirty();
        this.model.m_27624_();
        this.normal.m_8180_();
        return this;
    }

    @Override
    public ModelData multiply(Quaternion quaternion) {
        this.markDirty();
        this.model.m_27646_(quaternion);
        this.normal.m_8171_(quaternion);
        return this;
    }

    @Override
    public ModelData scale(float pX, float pY, float pZ) {
        this.markDirty();
        this.model.m_27644_(Matrix4f.m_27632_((float)pX, (float)pY, (float)pZ));
        if (pX == pY && pY == pZ) {
            if (pX > 0.0f) {
                return this;
            }
            this.normal.m_8156_(-1.0f);
        }
        float f = 1.0f / pX;
        float f1 = 1.0f / pY;
        float f2 = 1.0f / pZ;
        float f3 = Mth.m_14199_((float)(f * f1 * f2));
        this.normal.m_8178_(Matrix3f.m_8174_((float)(f3 * f), (float)(f3 * f1), (float)(f3 * f2)));
        return this;
    }

    @Override
    public ModelData translate(double x, double y, double z) {
        this.markDirty();
        this.model.m_162199_((float)x, (float)y, (float)z);
        return this;
    }

    @Override
    public ModelData mulPose(Matrix4f pose) {
        this.model.m_27644_(pose);
        return this;
    }

    @Override
    public ModelData mulNormal(Matrix3f normal) {
        this.normal.m_8178_(normal);
        return this;
    }
}

